/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#pragma once

// std
#include <memory>
#include <string>

// osdev::components::mqtt
#include "mqttclient.h"


class MqttSubscriberBase
{
public:
    /*!
     * \brief SubscriberBase
     */
    MqttSubscriberBase( const std::string &client_id );

    /*!
     * \brief ~SubscriberBase
     */
    virtual ~MqttSubscriberBase() {}

    /*!
     * \brief getClientId
     * \return
     */
    std::string getClientId() const;

    /*!
     * \brief connect
     * \param hostname
     * \param portnumber
     * \param username
     * \param password
     */
    void connect( const std::string &hostname, int portnumber, const std::string &username, const std::string &password );

    /*!
     * \brief subscribe
     * \param message_topic
     */
    void subscribe( const std::string &message_topic );

    /*!
     * \brief disconnect
     */
    void disconnect();

protected:
    /*!
     * \brief receive_data
     * \param message_topic
     * \param message_payload
     */
    virtual void receive_data( const std::string &message_topic, const std::string &message_payload ) = 0;

private:
    osdev::components::mqtt::MqttClient     m_mqtt_client;

};
