/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_MLOGICIDGENERATOR_H
#define OSDEV_COMPONENTS_MQTT_MLOGICIDGENERATOR_H

// std
#include <string>

// osdev::components::mqtt
#include "commondefs.h"

namespace osdev {
namespace components {
namespace mqtt {

class MqttIdGenerator
{
public:
    /**
     * @brief Generates a new MqttId, which is guaranteed to be unique.
     * @return A new unique MqttId.
     */
    static MqttId generate();

    /**
     * @brief Returns an MqttId that represents null.
     * @return An MqttId that represents null.
     */
    static MqttId nullId();

    /**
      * @brief Returns an MqttId based on a namespace uuid and a given string.
      * @param namespaceUuid The namespace in which the MqttId is generated.
      * @param name The name for which an MqttId is generated.
      */
    static MqttId nameId(MqttId namespaceUuid, const std::string& name);

    /**
      * @brief Returns an MqttId in the MQTT namespace for a given string.
      * @param name The name for which an MqttId is generated.
      */
    static MqttId nameId(const std::string& name);
};

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev

#endif  // OSDEV_COMPONENTS_MQTT_MLOGICIDGENERATOR_H
