/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_MQTTFAILURE_H
#define OSDEV_COMPONENTS_MQTT_MQTTFAILURE_H

// std
#include <string>

// paho
#include <MQTTAsync.h>

namespace osdev {
namespace components {
namespace mqtt {

/*!
 *  \brief  Class for paho mqtt failure response data.
 */
class MqttFailure
{
public:
    /*!
     *  \brief  Construct MqttFailure instance by copying information from the paho failure struct.
     *  \param  data Paho response failure data.
     */
    explicit MqttFailure(const MQTTAsync_failureData* data);

    /*!
     *  \return The command token
     */
    MQTTAsync_token token() const { return m_token; }

    /*!
     *  \return The failure code.
     */
    int code() const { return m_code; }

    /*!
     *  \return The failure message.
     *  \retval "no message" when no message is available.
     */
    const std::string& message() const { return m_message; }

    /*!
     *  \return string interpretation of the code.
     *  \note   negative codes are interpreted as paho error codes.
     */
    std::string codeToString() const;

private:
    MQTTAsync_token m_token;        ///< Command token.
    int m_code;                     ///< Failure code.
    std::string m_message;          ///< Optional message. Equal to "no message" when message is not available.
};

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev

#endif  // OSDEV_COMPONENTS_MQTT_MQTTFAILURE_H
