/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#pragma once

// std
#include <string>

namespace osdev {
namespace components {
namespace mqtt {

/*!
 *  \brief  Class that holds LWT ( Last Will & Testament ) context.
 */
class mqtt_LWT
{
public:
    /*!
     *  \brief Default CTor, empty LWT
     */
    mqtt_LWT()
        : m_topic()
        , m_message()
    {}

    /*!
     *  \brief  Constructor for LWT topic/message
     *  \param  topic    - The topic on which the LWT is published.
     *  \param  message  - The message published on broker disconnection.
     */
    mqtt_LWT( const std::string &topic, const std::string &message )
        : m_topic( topic )
        , m_message( message )
    {}

    const std::string& topic()   const { return m_topic; }
    const std::string& message() const { return m_message; }

private:
    std::string m_topic;
    std::string m_message;
};

}   // End namespace mqtt
}   // End namespace components
}   // End namespace osdev
