/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_MACRODEFS_H
#define OSDEV_COMPONENTS_MQTT_MACRODEFS_H

#include <type_traits>

#include "compiletimestring.h"

/// @brief Helper macro to stringify a symbol
#define OSDEV_COMPONENTS_STRINGIFY(x) #x

/// @brief Use this macro to safely stringify a symbol
/// This will also work for nested macro's
#define OSDEV_COMPONENTS_TOSTRING(x) OSDEV_COMPONENTS_STRINGIFY(x)

/// @brief Helper macro to combine two symbols
#define OSDEV_COMPONENTS_COMBINER(x, y) x##y

/// @brief Use this macro to safely combine two symbols
/// This will also work for nested macro's
#define OSDEV_COMPONENTS_COMBINE(x, y) OSDEV_COMPONENTS_COMBINER(x, y)

/// @brief Macro that reduces a path to the basename
#define OSDEV_COMPONENTS_MANAGEDBASEFILENAME \
    OSDEV_COMPONENTS_CSTRING_BOUNDED(__FILE__, osdev::components::rfind(__FILE__, '/') + 1, sizeof(__FILE__) - 1)

/// @brief Compiletime test if an instance derives from a certain base class
#define OSDEV_COMPONENTS_DERIVESFROM(derived, baseType)                                                                       \
    static_assert(std::is_base_of<baseType,                                                                                \
                      typename std::remove_pointer<typename std::remove_reference<decltype(derived)>::type>::type>::value, \
        OSDEV_COMPONENTS_TOSTRING(derived) " must be derived from " OSDEV_COMPONENTS_TOSTRING(baseType))

#endif  //OSDEV_COMPONENTS_MQTT_MACRODEFS_H
