/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_CONNECTIONSTATUS_H
#define OSDEV_COMPONENTS_MQTT_CONNECTIONSTATUS_H

// std
#include <ostream>

namespace osdev {
namespace components {
namespace mqtt {

/*!
 *  \brief  Enumeration for MQTT connection Status
 */
enum class ConnectionStatus
{
    Disconnected,               ///< Client is disconnected.
    DisconnectInProgress,       ///< Client is being disconnected.
    ConnectInProgress,          ///< Client is being connected.
    ReconnectInProgress,        ///< Client tries to reconnect.
    Connected,                  ///< Client is connected.
};

/*!
 *  \brief  Stream operator for the connection status
 */
std::ostream& operator<<(std::ostream &os, ConnectionStatus rhs);

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev

#endif  // OSDEV_COMPONENTS_MQTT_CONNECTIONSTATUS_H
