/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/

// std
#include <iostream>
#include <unistd.h>
#include <chrono>

#include "publisher.h"

enum TIME_RES
{
    T_MICRO,
    T_MILLI,
    T_SECONDS
};

std::uint64_t getEpochUSecs()
{
    auto tsUSec =std::chrono::time_point_cast<std::chrono::microseconds>(std::chrono::system_clock::now());
    return static_cast<std::uint64_t>(tsUSec.time_since_epoch().count());
}


void sleepcp( int number, TIME_RES resolution = T_MILLI )    // Cross-platform sleep function
{
    int factor = 0; // Should not happen..

    switch( resolution )
    {
        case T_MICRO:
            factor = 1;
            break;

        case T_MILLI:
            factor = 1000;
            break;

        case T_SECONDS:
            factor = 1000000;
        break;
    }

    usleep( number * factor );
}

int main( int argc, char* argv[] )
{
    // We're not using the command parameters, so we just want to keep the compiler happy.
    (void)argc;
    (void)argv;

    uint64_t messageNumber = 0;

    // Create the publisher, run it and publish a message every 0.001 sec.
    std::cout << "Create the publisher object : ";
    Publisher *pPublisher = new Publisher();
    if( pPublisher != nullptr )
    {
        std::cout << "{OK}" << std::endl;
        std::cout << "Connecting to the broker : ";
        pPublisher->connect( "localhost", 1883, "", "", "LWT-test", "connection disrupted.." );

        // Assume we are connected now, start publishing.
        while( 1 )
        {
            for( unsigned int nCount = 0; nCount < 10; nCount++ )
            {
                std::string payload = "<Timestamp value=\"" + std::to_string( getEpochUSecs() ) + "\" /><MessageNumber value=\"" + std::to_string( messageNumber ) + "\" />" ;
                pPublisher->publish( std::string( "test/publisher/TestPublisher_" + std::to_string( nCount ) ), payload );

                if( messageNumber > 2000000000 )
                {
                    messageNumber = -1;
                }
                messageNumber++;
            }
            sleepcp(100, T_MILLI);
        }
    }
    else
        return -1;

}
