#include <iostream>

#include "ModbusAdapter.h"

int main( int argc, char* argv[] )
{
    ModbusAdapter oModbus;
    ConnectionConfig oConfig( ConnectionPort::CP_EXTERNAL, 9600, Parity::PAR_NONE, 8, 1, 1 );

    std::cout << "========================= [START] Connection test ================================" << std::endl;
    oModbus.ModbusConnect( oConfig );
    if( oModbus.isConnected() )
    {
        std::cout << "Successful connected to : " << oConfig.getPort() << std::endl;
    }
    else
    {
        std::cout << "There was a problem connecting to : " << oConfig.getPort() << std::endl;
    }

    oModbus.ModbusDisconnect();
    if( !oModbus.isConnected() )
    {
        std::cout << "Successful disconnected from : " << oConfig.getPort() << std::endl;
    }
    else
    {
        std::cout << "There was a problem disconnecting from : " << oConfig.getPort() << std::endl;
    }
    std::cout << "========================= [END] Connection test ===============================" << std::endl;

    std::cout << "========================= [START] Reading test ================================" << std::endl;
    std::cout << "== Reading the Hold Registers                                                ==" << std::endl;
    oModbus.ModbusConnect( oConfig );
    if( oModbus.isConnected() )
    {
        std::cout << "Successful connected to : " << oConfig.getPort() << std::endl;
        modbusData returnValues = oModbus.ModbusReadHoldReg( 1, MODBUS_FC_READ_HOLDING_REGISTERS, 2 );
        if( returnValues.size() == 2 )
        {
            std::cout << "2 items returned from MODBUS_FC_READ_HOLDING_REGISTERS " << std::endl;
        }
        else
        {
            std::cout << "There was an error reading the Hold Registers " << std::endl;
            std::cout << "Number of items returned :  " << returnValues.size() << std::endl;
        }

        std::cout << "== Reading the Temperature                                                   ==" << std::endl;
        returnValues = oModbus.ModbusReadData( 0x01, MODBUS_FC_READ_INPUT_REGISTERS, 0x00, 0x02 );
        if( returnValues.size() == 0 )
        {
            std::cout << "No values returned " << std::endl;
        }
        else
        {
            std::cout << "Number of items returned :  " << returnValues.size() << std::endl;
        }
    }
    else
    {
        std::cout << "There was a problem connecting to : " << oConfig.getPort() << std::endl;
        return -1;
    }
    oModbus.ModbusDisconnect();
    std::cout << "=========================== [END] Reading test ================================" << std::endl;
}
