/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/

#ifndef OSDEV_COMPONENTS_JOBTIMER_H
#define OSDEV_COMPONENTS_JOBTIMER_H

#include <QTimer>
#include <QObject>
#include <QDateTime>
#include <QHash>
#include <QString>
#include <QVariant>
#include <QSharedPointer>

#include "jobdata.h"

namespace osdev {
namespace components {

/*  ______________________________________
 * / Got a dictionary? I want to know the \
 * \ meaning of life.                     /
 *  --------------------------------------
 *   \
 *    \
 *        .--.
 *       |o_o |
 *       |:_/ |
 *      //   \ \
 *     (|     | )
 *    /'\_   _/`\
 *    \___)=(___/
 *//*!
 * \brief   Instead of using separate timers, The job *is* the timer.
 */
class JobTimer : public QTimer
{
    Q_OBJECT
public:
    /*!
     * \brief   C'tor taking a jobdata structure to initialize the jobTimer.
     */
    JobTimer( const JobData& _jobData, QObject *_parent = nullptr );

    /*!
     * \brief   D'tor
     */
    virtual ~JobTimer();

    /*!
     * \brief   Get the jobData as a structure from the scheduled object.
     * \return  The data as object. Empty if no data was set.
     */
     JobData jobData() const { return m_jobData; }

private:
    /*!
     * \brief   Connect all internal signals and slots.
     */
    void connectSignalsSlots();

    JobData m_jobData;          ///< Structure to hold all jobInformation.

signals:
    /*!
     * \brief   Send the requested job by its name to all connected libraries.
     */
    void signalRunJob( const QString& jobName );

private slots:
    /*!
     * \brief   Will be called by the parent object (QTimer) times out.
     */
    void slotTimeOut();

};

}   /* End namespace components */
}   /* End namespace osdev      */

#endif  /* OSDEV_COMPONENTS_JOBTIMER_H */
