/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "pingthread.h"
#include "pingrunner.h"

#include "log.h"

#include <iostream>

using namespace osdev::components;

PingThread::PingThread( HostBuffer *input_queue, PingDataQueue *ping_buffer )
    : m_pHostBuffer( input_queue )
    , m_pQueue( ping_buffer )
{
    connect( this, &PingThread::finished, this, &PingThread::slotThreadFinished );
}

PingThread::~PingThread()
{

}

void PingThread::setPriority( QThread::Priority priority )
{
    if( this->isRunning() )
    {
        QThread::setPriority( priority );
    }
}

void PingThread::run()
{
    LogInfo( "[PingThread::run]", QString( "Starting thread..." ) )
    QString host_name;
    PingRunner l_pingRunner( m_pQueue );

    while( m_pHostBuffer->count() > 0 )
    {
        LogInfo( "[PingThread::run]", QString( "m_pHostBuffer has %1 entries.." ).arg( m_pHostBuffer->count() ) )
        host_name = m_pHostBuffer->getHost();
        LogInfo( "[PingThread::run]", QString( "m_pHostBuffer has %1 entries after getHost()" ).arg( m_pHostBuffer->count() ) )
        if( !host_name.isEmpty() )
        {
            LogInfo( "[PingThread::run]", QString( "[OK] Alive thread for host %1 created." ).arg( host_name ) );
            l_pingRunner.startPing( host_name );
        }
    }
    LogInfo( "[PingThread::run]", QString( "m_pHostBuffer is empty..." ) )
}

void PingThread::slotStartThread()
{
    LogInfo( "[PingThread::slotStartThread]", QString( "Running thread." ) );
    this->start();
}

void PingThread::slotThreadFinished()
{
    emit signalThreadFinished( this );
}
