/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
// local
#include "pingrunner.h"
#include "log.h"
#include "compatqt514.h"

// Qt
#include <QStringList>
#include <QtDebug>

// std
#include <iostream>

using namespace osdev::components;

PingRunner::PingRunner( QObject *parent )
    : QObject( parent )
    , m_shrBuf( nullptr )
    , m_host_to_ping( QString() )
{
    this->connectProcess();
}

PingRunner::PingRunner( PingDataQueue *l_shrBuffer, QObject *parent )
    : QObject( parent )
    , m_shrBuf( l_shrBuffer )
    , m_host_to_ping( QString() )
{
    this->connectProcess();
}

void PingRunner::connectProcess()
{
    // Use old style connect construction, as overloading in Signal / Slots
    // doesn't work without lambda functions.
}

PingRunner::~PingRunner()
{
}

void PingRunner::setSharedBuffer( PingDataQueue *l_shrBuffer )
{
    if( nullptr != l_shrBuffer )
    {
        m_shrBuf = l_shrBuffer;
    }
}

void PingRunner::startPing( const QString &host_to_ping )
{
    QProcess m_process;

    m_host_to_ping = host_to_ping;
    QStringList arguments( { "-n", "-q", "-c", "10", "-i", "0.2", "-W", "2", host_to_ping } );

    m_process.start( QString( "ping" ), arguments, QIODevice::ReadOnly );
    if( m_process.waitForFinished() )
    {
        LogInfo( "[PingRunner::startPing]", QString( "Process for host %1 done...." ).arg( m_host_to_ping ) )
        QStringList result;
        result << m_host_to_ping;
        result << QString( m_process.readAll() ).split( "\n", SKIP_EMPTY_PARTS );

        if( nullptr != m_shrBuf )
        {
            m_shrBuf->setData( m_host_to_ping, result );
        }
    }
    LogInfo( "[PingRunner::startPing]", QString( "Closing Communicationchannels for host %1 process" ).arg( m_host_to_ping ) )
    m_process.close();
}
