/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "pingdataqueue.h"
#include "log.h"

#include <QCoreApplication>

using namespace osdev::components;

PingDataQueue::PingDataQueue( QObject *parent )
    : QObject( parent )
    , m_qhData()
    , m_mutex()
{

}

PingDataQueue::~PingDataQueue()
{

}

void PingDataQueue::setData( PingData *data )
{
    QMutexLocker lock( &m_mutex );
    if( nullptr != data )
    {
        QUuid newID = QUuid::createUuid();
        m_qhData.insert( newID, data );
        emit signalNewDataReceived( newID );
        QCoreApplication::processEvents();
    }
    else
    {
        LogWarning( "[PingDataQueue::setData]", QString( "There was an error storing data : %1" ).arg( data->hostName() ) );
    }
}

void PingDataQueue::setData( const QString &host_name, const QStringList &data )
{
    PingData *l_data = new PingData( host_name, data );
    this->setData( l_data );
}

int PingDataQueue::num_items()
{
    return m_qhData.count();
}

QList<QUuid> PingDataQueue::getIds()
{
    return m_qhData.keys();
}

PingData* PingDataQueue::getData( const QUuid &id, bool remove )
{
    QMutexLocker lock( &m_mutex );
    if( remove )
        return m_qhData.take( id );
    else
        return m_qhData.value( id );
}
