/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_PINGDATA_H
#define OSDEV_COMPONENTS_PINGDATA_H

#include <QString>
#include <QStringList>
#include <QDateTime>

namespace osdev {
namespace components {

class PingData
{
public:
    PingData();
    PingData( const QString &host_name, const QStringList &output_data );

    virtual ~PingData();

    // All getters and setters.
    void                setTimeStamp( const QDateTime &time_stamp ) { m_time_stamp = time_stamp; }
    const QDateTime&    timeStamp() { return m_time_stamp; }

    void                setHostName( const QString &host_name ) { m_host_name = host_name; }
    const QString&      hostName() { return m_host_name; }

    void                setIpAddress( const QString &ip_address ) { m_ip_address = ip_address; }
    const QString&      ipAddress() { return m_ip_address; }

    void                setPacketLoss( const int packet_loss ) { m_packet_loss = packet_loss; }
    int                 packetLoss() { return m_packet_loss; }

    void                setRttMin( const float rtt_min ) { m_rtt_min = rtt_min; }
    float               rttMin() { return m_rtt_min; }

    void                setRttAvg( const float rtt_avg ) { m_rtt_avg = rtt_avg; }
    float               rttAvg() { return m_rtt_avg; }

    void                setRttMax( const float rtt_max ) { m_rtt_max = rtt_max; }
    float               rttMax() { return m_rtt_max; }

    void                setRttMdev( const float rtt_mdev ) { m_rtt_mdev = rtt_mdev; }
    float               rttMdev() { return m_rtt_mdev; }

    bool                available() { return m_available; }

    QString             asString();

private:
    void                parseOutputData( const QStringList &output_data );

private:
    QDateTime           m_time_stamp;
    QString             m_host_name;
    QString             m_ip_address;
    int                 m_packet_loss;
    float               m_rtt_min;
    float               m_rtt_avg;
    float               m_rtt_max;
    float               m_rtt_mdev;
    bool                m_available;
};

}       /* End namespace components */
}       /* End namespace osdev  */

#endif  /* OSDEV_COMPONENTS_PINGDATA_H */
