/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
// Local
#include "namesolver.h"
#include "log.h"

// System
#include <string.h>
#include <errno.h>

using namespace osdev::components;

QStringList NameSolver::hostname_to_ip( const QString &host_name )
{
    QStringList sResult;

    char ip_arr[100];

    struct addrinfo hints, *servinfo, *p;
    struct sockaddr_in *h;
    int rv;

    memset( &hints, 0, sizeof( hints ) );
    hints.ai_family     = AF_UNSPEC;
    hints.ai_socktype   = SOCK_STREAM;

    if( ( rv = getaddrinfo( host_name.toLatin1().data(), nullptr, &hints, &servinfo ) ) != 0 )
    {
        LogInfo( "[NameSolver::hostname_to_ip]", QString( "getaddrinfo : %1" ).arg( gai_strerror( rv ) ) );
        return sResult;
    }

    // Loop through all the results and connect to the first we can
    for( p = servinfo; p != nullptr; p = p->ai_next )
    {
        h = reinterpret_cast<struct sockaddr_in *>( p->ai_addr );
        strcpy( ip_arr, inet_ntoa( h->sin_addr ) );
        sResult.append( QString( reinterpret_cast<const char*>( ip_arr ) ) );
    }

    freeaddrinfo( servinfo );
    return sResult;
}
