/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_HTTPCLIENTTHREAD_H
#define OSDEV_COMPONENTS_HTTPCLIENTTHREAD_H

#include <QThread>
#include <QString>

namespace osdev {
namespace components {

class HttpClientThread : public QThread
{
    Q_OBJECT

public:
    HttpClientThread( const QString &ip_address, const QString &url, QObject *parent = nullptr );

    HttpClientThread( const HttpClientThread& ) = delete;
    HttpClientThread( const HttpClientThread&& ) = delete;
    HttpClientThread& operator=( const HttpClientThread& ) = delete;
    HttpClientThread& operator=( const HttpClientThread&& ) = delete;

    virtual ~HttpClientThread() {}

    void setPriority( QThread::Priority priority = QThread::NormalPriority );
    void run() override;

public:
    void    slotStartThread();

    void    slotThreadFinished();

signals:
    void    signalThreadFinished( QThread *thread );

};

}       /* End namespace components */
}       /* End namespace osdev  */

#endif  /* OSDEV_COMPONENTS_HTTPCLIENTTHREAD_H */
