/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_HTTPCLIENT_H
#define OSDEV_COMPONENTS_HTTPCLIENT_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QPointer>

/*_________________________________________
/ "I got into an elevator at work and     \
| this man followed in after me... I      |
| pushed '1' and he just stood there... I |
| said 'Hi, where you going?' He said,    |
| 'Phoenix.' So I pushed Phoenix. A few   |
| seconds later the doors opened, two     |
| tumbleweeds blew in... we were in       |
| downtown Phoenix. I looked at him and   |
| said 'You know, you're the kind of guy  |
| I want to hang around with.' We got     |
| into his car and drove out to his shack |
| in the desert. Then the phone rang. He  |
| said 'You get it.' I picked it up and   |
| said 'Hello?'... the other side said    |
| 'Is this Steven Wright?'... I said      |
| 'Yes...' The guy said 'Hi, I'm Mr.      |
| Jones, the student loan director from   |
| your bank... It seems you have missed   |
| your last 17 payments, and the          |
| university you attended said that they  |
| received none of the $17,000 we loaned  |
| you... we would just like to know what  |
| happened to the money?' I said, 'Mr.    |
| Jones, I'll give it to you straight. I  |
| gave all of the money to my friend      |
| Slick, and with it he built a nuclear   |
| weapon... and I would appreciate it if  |
| you never called me again."             |
|                                         |
\ -- Steven Wright                        /
 -----------------------------------------
     \
      \
         .--.
        |o_o |
        |:_/ |
       //   \ \
      (|     | )
     /'\_   _/`\
     \___)=(___/
*/

namespace osdev {
namespace components {

class HttpClient : public QObject
{
    Q_OBJECT

public:
    /// Default CTor
    explicit HttpClient( QObject *parent = nullptr );

signals:
    /// Triggered when net data comes in
    void signalDataReceived( const QString &ip_address, const QString &data, QObject *client = nullptr ) ;

public slots:
    /*!
     * \brief sendRequest   - Sends the request to the ip_address with the argument. ( Full URL ).
     * \param ip_address    - The ip_address we send the request to...
     * \param argument      - The argument that will complete the URL.
     */
    void sendRequest( const QString &ip_address, const QString &argument = "/" );

private slots:
    void slotHttpRequestFinished( QNetworkReply *data );

private:    // Methods
    void connectSignalsToSlots();

private:    // Members ( Giggity! )
    QPointer<QNetworkAccessManager> m_pNetworkManager;
};

}       /* End namespace components */
}       /* End namespace osdev  */

#endif  /* OSDEV_COMPONENTS_HTTPCLIENT_H */
