/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_HOSTBUFFER_H
#define OSDEV_COMPONENTS_HOSTBUFFER_H

#include <QObject>
#include <QStringList>
#include <QMutexLocker>
#include <QMutex>

namespace osdev {
namespace components {

class HostBuffer : public QObject
{
    Q_OBJECT

public:
    /// Default CTor
    HostBuffer( QObject *parent = nullptr );

    /// Overloaded constuctor taken a host list during initialisation
    HostBuffer( const QStringList &host_list, QObject *parent = nullptr );

    /// Adds a single host to the buffer
    int addHost( const QString &host );

    /// Adds a list of hosts. It will not overwrite hosts already present but adds them.
    int addHosts( const QStringList &host_list );

    /// Retrieve -a- host from the buffer. It will be removed!
    QString getHost();

    /// Get the number of hosts in the buffer
    int count();

private:
    QStringList     m_data;
    QMutex          m_mutList;
};

}       /* End namespace components */
}       /* End namespace osdev  */

#endif  /* OSDEV_COMPONENTS_HOSTBUFFER_H */
