/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "hostbuffer.h"

using namespace osdev::components;

HostBuffer::HostBuffer( QObject *parent )
    : QObject( parent )
    , m_data( QStringList() )
    , m_mutList()
{

}

HostBuffer::HostBuffer( const QStringList &host_list, QObject *parent )
    : QObject( parent )
    , m_data( host_list )
    , m_mutList()
{

}

int HostBuffer::addHost( const QString &host )
{
    QMutexLocker lock( &m_mutList );
    m_data.append( host );

    return m_data.size();
}

int HostBuffer::addHosts( const QStringList &host_list )
{
    for( QString host : host_list )
    {
        this->addHost( host );
    }
    return m_data.size();
}

QString HostBuffer::getHost()
{
    QMutexLocker lock( &m_mutList );
    if( m_data.size() > 0 )
    {
        return m_data.takeFirst();
    }

    return QString();
}

int HostBuffer::count()
{
    QMutexLocker lock( &m_mutList );
    return m_data.size();
}
