/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "plugin.h"

namespace osdev  {
namespace components {

Plugin::Plugin( const QString& pluginName, const QString& pluginFile, const QString& pluginPath,
                const QString& pluginConfig, const QUuid& pluginUuid,
                QObject* ptr_plugin )
    : m_pluginName( pluginName )
    , m_pluginFile( pluginFile )
    , m_pluginPath( pluginPath )
    , m_pluginConfigurationFile( pluginConfig )
    , m_pluginUuid( pluginUuid )
    , m_plugin( ptr_plugin )
{
}

Plugin::Plugin( const Plugin& other )
    : Plugin(other.name(), other.fileName(), other.path(), other.config(), other.uuid(), other.plugin())
{
}

Plugin& Plugin::operator=( const Plugin& other )
{
    if(this != &other) {
        m_pluginName = other.name();
        m_pluginFile = other.fileName();
        m_pluginPath = other.path();
        m_pluginConfigurationFile = other.config();
        m_pluginUuid = other.uuid();
        m_plugin = other.plugin();
    }
    return *this;
}

QString Plugin::asString()
{
    QString PluginData = QString( "[PluginName = %1] [PluginFile = %2] [PluginPath = %3] [PluginConfigFile = %4] [PluginUUId = %5]" )
                             .arg( m_pluginName ).arg( m_pluginFile ).arg( m_pluginPath ).arg( m_pluginConfigurationFile ).arg( m_pluginUuid.toString() );

    return PluginData;
}

} // End namespace components
} // End namespace osdev

