/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_CONVERSIONUTILS_H
#define OSDEV_COMPONENTS_CONVERSIONUTILS_H

#include <QVariant>
#include <QString>
#include <QMetaType>
#include <QHash>

namespace osdev  {
namespace components {

/*!
 * \brief The ConversionUtils class converts an string expression to a QVariant Type.
 *        The modelmapper is build from a configurationfile and fieldtypes are given in strings
 *        By mapping those string expressions to the corresponding QVariant Type, we ensure the
 *        data is handled correctly.
 *
 *        The number of types is *everything* mentioned in to Qt-documentation although
 *        it is doubtful we'll ever use everything.
 *
 *        Instead of using the nameToType method of QVariant, we did our own translation table,
 *        making it possible to use Database types or any type whatsoever.
 */

class ConversionUtils
{
public:
    ConversionUtils() = delete;

    static QVariant::Type stringToQvarType( const QString& sValueType );
    static QStringList getTypes();

    static QVariant convertToType( const QVariant &varValue, QVariant::Type varType );
    static QVariant convertToType( const QVariant &varValue, const QString& varType );
};

}       /* End namespace components */
}       /* End namespace osdev      */

#endif  /* OSDEV_COMPONENTS_CONVERSIONUTILS_H */
