/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "conversionutils.h"

using namespace osdev::components;

namespace
{

QHash<QString, QVariant::Type> gQHTypes(
    {
        { "UNKNOWN", QVariant::Invalid },
        { "BITARRAY", QVariant::BitArray },
        { "BITMAP", QVariant::Bitmap },
        { "BOOL", QVariant::Bool },
        { "BRUSH", QVariant::Brush },
        { "BYTEARRAY", QVariant::ByteArray },
        { "CHAR", QVariant::Char },
        { "COLOR", QVariant::Color },
        { "CURSOR", QVariant::Cursor },
        { "DATE", QVariant::Date },
        { "DATETIME", QVariant::DateTime },
        { "DOUBLE", QVariant::Double },
        { "EASINGCURVE", QVariant::EasingCurve },
        { "UUID", QVariant::Uuid },
        { "MODELINDEX", QVariant::ModelIndex },
        { "FONT", QVariant::Font },
        { "HASH", QVariant::Hash },
        { "ICON", QVariant::Icon },
        { "IMAGE", QVariant::Image },
        { "INT", QVariant::Int },
        { "SMALLINT", QVariant::Int },
        { "KEYSEQUENCE", QVariant::KeySequence },
        { "LINE", QVariant::Line },
        { "LINEF", QVariant::LineF },
        { "LIST", QVariant::List },
        { "LOCALE", QVariant::Locale },
        { "LONGLONG", QVariant::LongLong },
        { "MAP", QVariant::Map },
        { "MATRIX", QVariant::Matrix },
        { "TRANSFORM", QVariant::Transform },
        { "MATRIX4X4", QVariant::Matrix4x4 },
        { "PALETTE", QVariant::Palette },
        { "PEN", QVariant::Pen },
        { "PIXMAP", QVariant::Pixmap },
        { "POINT", QVariant::Point },
        { "POINTF", QVariant::PointF },
        { "POLYGON", QVariant::Polygon },
        { "POLYGONF", QVariant::PolygonF },
        { "QUATERNION", QVariant::Quaternion },
        { "RECT", QVariant::Rect },
        { "RECTF", QVariant::RectF },
        { "REGEXP", QVariant::RegExp },
        { "REGULAREXPRESSION", QVariant::RegularExpression },
        { "REGION", QVariant::Region },
        { "SIZE", QVariant::Size },
        { "SIZEF", QVariant::SizeF },
        { "SIZEPOLICY", QVariant::SizePolicy },
        { "STRING", QVariant::String },
        { "STRINGLIST", QVariant::StringList },
        { "TEXTFORMAT", QVariant::TextFormat },
        { "TEXTLENGTH", QVariant::TextLength },
        { "TIME", QVariant::Time },
        { "UINT", QVariant::UInt },
        { "ULONGLONG", QVariant::ULongLong },
        { "URL", QVariant::Url },
        { "VECTOR2D", QVariant::Vector2D },
        { "VECTOR3D", QVariant::Vector3D },
        { "VECTOR4D", QVariant::Vector4D },
        { "USERTYPE", QVariant::UserType },

        // PostGreSQL Datatypes, also aliases for historical purposes

        { "BIGINT", QVariant::Int },
        { "INT8", QVariant::Int },
        { "BIGSERIAL", QVariant::Int },
        { "SERIAL8", QVariant::Int },
        { "BIT", QVariant::String },
        { "BIT VARYING", QVariant::String },
        { "VARBIT", QVariant::String },
        { "BOOLEAN", QVariant::Bool },
        { "BYTEA", QVariant::String },
        { "CHARACTER", QVariant::String },
        { "CHAR", QVariant::String },
        { "CHARACTER VARYING", QVariant::String },
        { "CIDR", QVariant::String },
        { "DATE", QVariant::Date },
        { "DOUBLE PRECISION", QVariant::Double },
        { "FLOAT8", QVariant::Double },
        { "INET", QVariant::String },
        { "INTEGER", QVariant::Int },
        { "INT4", QVariant::Int },
        { "JSON", QVariant::String },
        { "MACADDR", QVariant::String },
        { "REAL", QVariant::Double },
        { "FLOAT4", QVariant::Double },
        { "INT2", QVariant::Int },
        { "SMALLSERIAL", QVariant::Int },
        { "SERIAL2", QVariant::Int },
        { "SERIAL", QVariant::Int },
        { "SERIAL4", QVariant::Int },
        { "TEXT", QVariant::String },
        { "TIME", QVariant::Time },
        { "TIMESTAMP", QVariant::DateTime },
        { "TIMESTAMP WITH TIME ZONE", QVariant::DateTime },
        { "TIMESTAMPTZ", QVariant::DateTime },
        { "TSQUERY", QVariant::String },
        { "UUID", QVariant::Uuid },
        { "XML", QVariant::String }
    });

} // anonymous

// static
QVariant::Type ConversionUtils::stringToQvarType( const QString& sValueType )
{
    return gQHTypes.value( sValueType.toUpper() );
}

// static
QStringList ConversionUtils::getTypes()
{
    return QStringList( gQHTypes.keys() );
}

// static
QVariant ConversionUtils::convertToType( const QVariant &varValue, QVariant::Type varType )
{
    QVariant varResult = varValue;

    if( varValue.type() == QVariant::Bool && varType == QVariant::String )
    {
        if( varValue.toBool() )
        {
            varResult = QVariant( QString( "1" ) );
        }
        else
        {
            varResult = QVariant( QString( "0" ) );
        }
    }
    else if( varValue.type() == QVariant::Bool && varType == QVariant::Int )
    {
        if( varValue.toBool() )
        {
            varResult = QVariant( 1 );
        }
        else
        {
            varResult = QVariant( 0 );
        }
    }

    return varResult;
}

// static
QVariant ConversionUtils::convertToType(const QVariant &varValue, const QString &varType )
{
    return convertToType( varValue, stringToQvarType( varType ) );
}
