/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
// osdev::caelus
#include "argumentparserbase.h"

using namespace osdev::components;

ArgumentParserBase::ArgumentParserBase( const QStringList& arguments )
    : m_argument_list( arguments )
{
}

ArgumentParserBase::~ArgumentParserBase() = default;

void ArgumentParserBase::setArgumentList( const QStringList &arg_list )
{
    m_argument_list = arg_list;
}

QString ArgumentParserBase::getArgumentValue( const QString &argument_switch ) const
{
    QString l_result = QString();

    if( 1 == m_argument_list.count( argument_switch ) )
    {
        l_result = m_argument_list.at( m_argument_list.indexOf( argument_switch ) + 1 );
    }

    return l_result;
}
