#pragma once

#include <cstdint>
#include <string>
#include <variant>

namespace osdev::components {

class Variant
{
public:
    enum Type {
        Invalid,    // Unknown
        Bool,       // bool
        Double,     // double
        Float,      // float
        Char,       // char
        String,     // std::string
        UInt8,      // uint8_t
        UInt16,     // uint16_t
        UInt64,     // uint64_t
        Int         // int          -->> Size determined by platform and compiler
    };

    /*!
     *  All Constructors available.
     *  The type of the argument determines the internal type of the variant
     */
    Variant() : m_variable() {};
    Variant(bool value) : m_variable(value) {};
    Variant(int value) : m_variable(value) {};
    Variant(double value) : m_variable(value) {};
    Variant(float value) : m_variable(value) {};
    Variant(char value) : m_variable(value) {};
    Variant(std::string value) : m_variable(value) {};
    Variant(uint8_t value) : m_variable(value) {};
    Variant(uint16_t value) : m_variable(value) {};
    Variant(uint64_t value) : m_variable(value) {};

    /// Return the type of the value stored in this variant
    Variant::Type getType();

    /// Check to see if the value can be converted to the desired type.
    /// @param  - The requested type as an enum
    /// @return - true if the conversion can happen. False if not.
    bool CanConvert(Variant::Type typeWanted);

    bool            toBool();
    double          toDouble();
    float           toFloat();
    char            toChar();
    std::string     toString();
    int             toInt();
    uint8_t         toUInt8();
    uint16_t        toUInt16();
    uint64_t        toUInt64();



private:
    std::variant<bool, int,
                 double, float,
                 char, std::string,
                 uint8_t, uint16_t,
                 uint64_t> m_variable;

};

}   /* End namespace osdev::components */
