#include "Variant.h"

using namespace osdev::components;

Variant::Type Variant::getType()
{
    if(std::holds_alternative<bool>(m_variable))
    {
        return Variant::Type::Bool;
    }
    else if(std::holds_alternative<int>(m_variable))
    {
        return Variant::Type::Int;
    }
    else if(std::holds_alternative<double>(m_variable))
    {
        return Variant::Type::Double;
    }
    else if(std::holds_alternative<float>(m_variable))
    {
        return Variant::Type::Float;
    }
    else if(std::holds_alternative<char>(m_variable))
    {
        return Variant::Type::Char;
    }
    else if(std::holds_alternative<std::string>(m_variable))
    {
        return Variant::Type::String;
    }
    else if(std::holds_alternative<uint8_t>(m_variable))
    {
        return Variant::Type::UInt8;
    }
    else if(std::holds_alternative<uint16_t>(m_variable))
    {
        return Variant::Type::UInt16;
    }
    else if(std::holds_alternative<uint64_t>(m_variable))
    {
        return Variant::Type::UInt64;
    }

    return Variant::Type::Invalid;
}

bool Variant::CanConvert(Variant::Type typeWanted)
{
    switch(typeWanted)
    {
        case Variant::Bool:
        {
            return std::holds_alternative<bool>(m_variable);
        }
        case Variant::Int:
        {
            return std::holds_alternative<int>(m_variable);
        }
        case Variant::Double:
        {
            return std::holds_alternative<double>(m_variable);
        }
        case Variant::Float:
        {
            return std::holds_alternative<float>(m_variable);
        }
        case Variant::Char:
        {
            return std::holds_alternative<char>(m_variable);
        }
        case Variant::String:
        {
            return std::holds_alternative<std::string>(m_variable);
        }
        case Variant::UInt8:
        {
            return std::holds_alternative<uint8_t>(m_variable);
        }
        case Variant::UInt16:
        {
            return std::holds_alternative<uint16_t>(m_variable);
        }
        case Variant::UInt64:
        {
            return std::holds_alternative<uint64_t>(m_variable);
        }
        case Variant::Invalid:
        {
            return false;
        }
    }
    return false;
}

bool Variant::toBool()
{
    return std::get<bool>(m_variable);
}

int Variant::toInt()
{
    return std::get<int>(m_variable);
}

double Variant::toDouble()
{
    return std::get<double>(m_variable);
}

float Variant::toFloat()
{
    return std::get<float>(m_variable);
}

char Variant::toChar()
{
    return std::get<char>(m_variable);
}

std::string Variant::toString()
{
    return std::get<std::string>(m_variable);
}

uint8_t Variant::toUInt8()
{
    return std::get<uint8_t>(m_variable);
}

uint16_t Variant::toUInt16()
{
    return std::get<uint16_t>(m_variable);
}

uint64_t Variant::toUInt64()
{
    return std::get<uint64_t>(m_variable);
}
