#!/bin/bash

REPO_DIR=${PWD}
DIRECTORIES=`ls -1d *`

function create_source_file() {
    SOURCE_FILE="$1.pri"

    echo "Building file : ${SOURCE_FILE}"
    if [ -e ${SOURCE_FILE} ]; then
        rm -vf ${SOURCE_FILE}
    fi

    HEADERFILES=`ls -1 *.h`
    SOURCEFILES=`ls -1 *.cpp`
    HEADERLINE="HEADERS += ${HEADERFILES}"
    SOURCELINE="SOURCES += ${SOURCEFILES}"

    echo "=================================="
    echo "== ${SOURCE_FILE} =="
    echo "=================================="
    echo "== A D D I N G   H E A D E R S  =="
    echo "=================================="
    echo ${HEADERLINE} | sed 's/=\ /=\ \$\$PWD\//g' | sed 's/.h\ /.h\ \\\n\t\t\$\$PWD\//g' > ./${SOURCE_FILE}
    echo " " >> ./${SOURCE_FILE}
    echo "=================================="
    echo "==  A D D I N G  S O U R C E S  =="
    echo "=================================="
    echo ${SOURCELINE} | sed 's/=\ /=\ \$\$PWD\//g' | sed 's/.cpp\ /.cpp\ \\\n\t\t\$\$PWD\//g' >> ./${SOURCE_FILE}
    echo " "
    echo " "
    echo " "
    echo " "
}

for directory in ${DIRECTORIES}
do
    if [ -d ${REPO_DIR}/${directory} ]; then
        cd ${REPO_DIR}/${directory}
        create_source_file ${directory}
        cd ${REPO_DIR}
    else
        echo "${REPO_DIR}/${directory} is not a directory"
    fi
done
