/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ****************************************************************************/
#include "daemonbase.h"
#include <cstdlib>

using namespace osdev::components::daemon;
using namespace std::chrono_literals;

class MyExampleDaemon : public DaemonBase
{
public:
    void on_start(const daemonconfig &config) override
    {
        /// Called once after daemon starts automatically with system startup 
        /// or when you manually call `$ system,ctl start MyExampleDaemon`

        /// Initialize your code here...



        daemonlog::info("MyExampleDaemon::on_start(): MyExampleDaemon version: " + config.get("version") + " started successfully!");
    }

    void on_update() override
    {
        /// Called every DURATION set in set_update_duration()...
        
        /// Update your code here

        daemonlog::info("MyExampleDaemon::on_update()");
    }

    void on_stop() override
    {
        /// Called once before daemon is about to exit with system shutdown or when you manually call `$ systemctl stop MyExampleDaemon`
        /// Cleanup your code here...

        daemonlog::info("MyExampleDaemon::on_stop()");
    }

    void on_reload(const daemonconfig &cfg) override 
    {
        /// Called once after your daemon's config fil is updated then reloaded with `$ systemctl reload MyExampleDaemon`
        /// Handle your config updates here...

        daemonlog::info("MyExampleDaemon::on_reload(): new daemon version from updated config: " + cfg.get("version"));
    }
};


int main(int argc, char *argv[])
{
    MyExampleDaemon oDaemon;                            // Create the daemon instance.

    oDaemon.set_name("MyAweSomeExampleDaemon");         // Set daemon name to identify logs in syslog
    oDaemon.set_update_duration(3s);                    // Set duration to sleep before triggering the on_update callback 3 seconds.
    oDaemon.set_cwd("/root");                           // set daemon's current working directory to roots home-folder
    oDaemon.run(argc, argv);                            // run the daemon

    return(EXIT_SUCCESS);                               // Close the main process now the child process is running.
}