#!/bin/bash

# $1: cmake-file-filename
function sync-file()
{
  echo ---------- Syncing $1 started

  cp -f ../../mlogic_support/cmake/$1 $1
  if [ $? -ne 0 ] ; then
    echo ---------- Syncing $1 failed
    return 1
  fi

  echo ---------- Syncing $1 finished
}

# We don't copy installation.cmake, because the includes files are in the src folder.
#  datacollector is different in this respect from the other repositories.
MLOGIC_CMAKE_FILES="artifacts.cmake
compiler.cmake
config.cmake.in
FindGMock.cmake
library.cmake
packaging.cmake
projectheader.cmake
qtmoc.cmake"

# Process the cmake files
cd $(dirname $(readlink -f $0)) || exit 1
for cmake_file in ${MLOGIC_CMAKE_FILES}
do
  sync-file ${cmake_file}
done
