# @brief Defines the project name, version and binary dir.
# @param CURRENT_PROJECT_NAME The name of the project to define.
# @param CURRENT_PROJECT_BINARY_DIR [optional] Override for the default project binary dir (PROJECT_BINARY_DIR for executables, CMAKE_BINARY_DIR for libraries).
macro ( project_header CURRENT_PROJECT_NAME )

# Determine the version and fill the following variables :
# SOVERSION : The tag from the git-repository. Not necessarily a number-only string.
find_package(Git QUIET)

if(GIT_FOUND)
    if( EXISTS "${PROJECT_SOURCE_DIR}/.git")
        execute_process(COMMAND ${GIT_EXECUTABLE} describe --abbrev=0 --tags
            WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
            OUTPUT_VARIABLE CURRENT_PROJECT_VERSION
            OUTPUT_STRIP_TRAILING_WHITESPACE
            RESULT_VARIABLE GIT_SUBMOD_RESULT)

        # Exit code will be 128 if no tags are present
        if( ${GIT_SUBMOD_RESULT} EQUAL 128 )
            set(CURRENT_PROJECT_VERSION "0.0.1")
        endif()



        message( STATUS "================================================================" )
        message( STATUS "Found the following tag : ${CURRENT_PROJECT_VERSION}")
        message( STATUS "================================================================" )
    else()
        message( STATUS ".git directory does not exists..")
        message( STATUS "Project directory : ${PROJECT_SOURCE_DIR}")
    endif()
else()
    message( STATUS "git-command not found....")
    message( FATAL "Unable to determine the version of the software.")
endif()


message( STATUS "" )
message( STATUS "================================================================" )
message( STATUS "Creating Makefile of ${CURRENT_PROJECT_NAME}" )
message( STATUS "================================================================" )
message( STATUS "CURRENT_PROJECT_VERSION: ${CURRENT_PROJECT_VERSION}" )

set(SOVERSION "${CURRENT_PROJECT_VERSION}")
set(VERSION "${CURRENT_PROJECT_VERSION}")

project(${CURRENT_PROJECT_NAME} VERSION ${CURRENT_PROJECT_VERSION})
set_property(GLOBAL PROPERTY GLOBAL_DEPENDS_NO_CYCLES 1)

set ( optional_macro_args ${ARGN} )
list ( LENGTH optional_macro_args num_optional_args )
if ( ${num_optional_args} GREATER 0 )
    # Set project binary dir override to the specified value
    list ( GET optional_macro_args 0 CURRENT_PROJECT_BINARY_DIR )
    set ( ${PROJECT_NAME}_CURRENT_BINARY_DIR ${CURRENT_PROJECT_BINARY_DIR} CACHE STRING "${PROJECT_NAME} binary dir" FORCE )
endif()

endmacro()
