set( PACKAGING_CURRENT_CMAKE_DIR ${CMAKE_CURRENT_LIST_DIR} )

# @brief Creates component packages. Can be executed by calling "make package".
function(package_component)

# Determine build architecture
execute_process(
    COMMAND uname -m
    COMMAND tr -d '\n'
    OUTPUT_VARIABLE ARCHITECTURE
)

# Set package name
# Known issue: Due to the way cpack works (only evaluated once), the PROJECT_NAME will be the last package to
# call this function. We worked around this by including packaging.cmake only from 1 location in the repository.
# However, in a superbuild (i.e. from an mlogic parent directory building all repositories at once),
# this will yield an erroneous package name (usually datacollector, as that is the last project to be evaluated).
# In order to prevent dynamic package names caused by different build directories,
# The package name is set to a fixed value. The actual name of the rpm and package will be determined by
# other variable values such as the component name and version, leading to uniquely identifiable packages.
set(CPACK_PACKAGE_NAME osdev)

# Set package version numbers
set(CPACK_PACKAGE_VERSION_MAJOR "${PROJECT_VERSION_MAJOR}")
set(CPACK_PACKAGE_VERSION_MINOR "${PROJECT_VERSION_MINOR}")
set(CPACK_PACKAGE_VERSION_PATCH "${PROJECT_VERSION_PATCH}")
# The release number is not part of CPACK_PACKAGE_VERSION and is dealt with seperately (see below)
set(CPACK_PACKAGE_VERSION "${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}")
message( STATUS "Packaging ${CPACK_PACKAGE_NAME} ${CPACK_PACKAGE_VERSION} for ${ARCHITECTURE}.")

set(CPACK_PACKAGE_RELEASE "1")
if (CURRENT_PROJECT_VERSION_RELEASENR)
    set(CPACK_PACKAGE_RELEASE ${CURRENT_PROJECT_VERSION_RELEASENR})
endif()

# Build CPack driven installer packages
include(InstallRequiredSystemLibraries)

# This doesn't seem to work, only the specific archive variables (_RPM_, _DEB_) seem to work
#set(CPACK_ARCHIVE_COMPONENT_INSTALL ON)
set(CPACK_COMPONENTS_IGNORE_GROUPS 1)
# Enable the line below if the repository being built has only 1 target that's installed
# (No longer necessary, as we now have at least 2 components: runtime and development components.)
#set(CPACK_COMPONENTS_ALL ${CPACK_PACKAGE_NAME} ${CPACK_PACKAGE_NAME}-devel)

# Enable DESTDIR and copy CMAKE_INSTALL_PREFIX, which requires disabling rpm relocatability
set(CPACK_SET_DESTDIR 1)
set(CPACK_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX})
set(CPACK_PACKAGE_RELOCATABLE OFF)

# Set package metadata
if (EXISTS "${PACKAGING_CURRENT_CMAKE_DIR}/../../../COPYING.OSDEV")
    set(CPACK_RESOURCE_FILE_LICENSE "${PACKAGING_CURRENT_CMAKE_DIR}/../../../COPYING.OSDEV")
endif()
if (EXISTS "${PACKAGING_CURRENT_CMAKE_DIR}/../../../README.md")
    set(CPACK_RESOURCE_FILE_README "${PACKAGING_CURRENT_CMAKE_DIR}/../../../README.md")
endif()
set(CPACK_SYSTEM_NAME "${ARCHITECTURE}")
set(CPACK_PACKAGE_FILE_NAME "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION}.${CURRENT_PROJECT_VERSION_LETTER}-${CPACK_PACKAGE_RELEASE}.${ARCHITECTURE}")

# RPM specific fields
set(CPACK_RPM_PACKAGE_ARCHITECTURE "${ARCHITECTURE}")
set(CPACK_RPM_COMPONENT_INSTALL ON)
set(CPACK_RPM_PACKAGE_GROUP "${CPACK_PACKAGE_NAME}-${REPOSITORY_PACKAGE_NAME}")
# Unfortunately, CPACK_RPM_PACKAGE_RELEASE isn't inherited from CPACK_PACKAGE_RELEASE automatically.
set(CPACK_RPM_PACKAGE_RELEASE ${CPACK_PACKAGE_RELEASE})
set(CPACK_RPM_PACKAGE_VENDOR ${CURRENT_PROJECT_MANUFACTURER_CODE})
set(CPACK_RPM_PACKAGE_SUMMARY "${CPACK_PACKAGE_NAME} package")
set(CPACK_RPM_PACKAGE_DESCRIPTION "${CPACK_RPM_PACKAGE_SUMMARY}")
set(CPACK_RPM_PACKAGE_LICENSE "${CURRENT_PROJECT_MANUFACTURER_CODE}")

# Select CPack generators
set(CPACK_GENERATOR "RPM")

# Exclude certain system directories from the rpm
set(CPACK_RPM_EXCLUDE_FROM_AUTO_FILELIST_ADDITION /usr;/etc;/etc/systemd;/var;${USR_LOCAL_DIR};${LD_SO_CONF_D_DIR};${SYSTEMD_CONFIG_DIR};${VAR_LOG_DIR};${VAR_RUN_DIR})

# This line should come last
include(CPack)

endfunction(package_component)
