# @brief Adds a single shared or static library target and performs related actions,
# such as target properties and some packaging variables.
# @note The default binary directory is CMAKE_BINARY_DIR, but can be overridden by specifying the ${PROJECT_NAME}_CURRENT_BINARY_DIR.
function(add_libraries)

message( STATUS "${PROJECT_NAME} linking libraries : ${ARGN}")

# Use CMAKE_BINARY_DIR by default, but override if necessary.
set(CURRENT_PROJECT_BINARY_DIR ${CMAKE_BINARY_DIR})
if (${PROJECT_NAME}_CURRENT_BINARY_DIR)
    set(CURRENT_PROJECT_BINARY_DIR ${${PROJECT_NAME}_CURRENT_BINARY_DIR})
endif()
message(STATUS "CURRENT_PROJECT_BINARY_DIR : ${CURRENT_PROJECT_BINARY_DIR}")

if( ${BUILD_STATIC} )
    if(${BUILD_STATIC} STREQUAL "ON")
        set(SHARED_OR_STATIC "STATIC")
    else()
        set(SHARED_OR_STATIC "SHARED")
    endif()
else()
    set(SHARED_OR_STATIC "SHARED")
endif()

add_library( ${PROJECT_NAME} ${SHARED_OR_STATIC}
    ${SRC_LIST}
)

target_link_libraries( ${PROJECT_NAME}
    ${ARGN}
)

set_target_properties( ${PROJECT_NAME}
    PROPERTIES
        VERSION ${PROJECT_VERSION}
        SOVERSION ${PROJECT_VERSION_MAJOR}
        LIBRARY_OUTPUT_DIRECTORY ${CURRENT_PROJECT_BINARY_DIR}/lib
        ARCHIVE_OUTPUT_DIRECTORY ${CURRENT_PROJECT_BINARY_DIR}/lib
)

endfunction()
