# @brief Tries to find the module with find_package, and uses CMAKE_INSTALL_PREFIX (see documentation).
# If the module can't be found, includes the directory by the specified module path.
# @param module The name of the module on which a dependency is added
# @param modulepath The relative path of the module wrt the current project
# @param moduleincludepath [optional] The relative path to the include directory
# @note Needs to be a macro because of the scope of the variables that are set by find_package.
macro(depend_module module modulepath)
    message(STATUS "module     : ${module}")
    message(STATUS "modulepath : ${modulepath}")

    set ( optional_macro_args ${ARGN} )
    list ( LENGTH optional_macro_args num_optional_args )
    if ( ${num_optional_args} GREATER 0 )
        list ( GET optional_macro_args 0 moduleincludepath )
    else()
        set ( moduleincludepath include )
    endif()
    message(STATUS "moduleincludepath : ${moduleincludepath}")

    find_package(${module} CONFIG QUIET)
    message( STATUS "${module}_FOUND: ${${module}_FOUND}" )

    string( TOUPPER ${module} MODULE_NAME_UPPER )

    # check if the constructed variable name exists and if so check also the content.
    if ( NOT ${${module}_FOUND} )
        if ( NOT TARGET ${module} )
            message( STATUS "Adding subdirectory ${modulepath}/${module} as subdirectory ${CMAKE_CURRENT_LIST_DIR}/staging/${module}." )
            add_subdirectory(${modulepath}/${module} staging/${module})
        endif()

        set( ${MODULE_NAME_UPPER}_INCLUDE_DIR ${modulepath}/${module}/${moduleincludepath} CACHE STRING "${module} include path" FORCE )
        set( ${MODULE_NAME_UPPER}_LIB_DIR "${CMAKE_CURRENT_BINARY_DIR}" CACHE STRING "${module} library path" FORCE )
        set( ${MODULE_NAME_UPPER}_LIB_NAME "${module}" CACHE STRING "${module} library name" FORCE )
    endif()

    message( STATUS "${MODULE_NAME_UPPER}_INCLUDE_DIR: ${${MODULE_NAME_UPPER}_INCLUDE_DIR}" )
    message( STATUS "${MODULE_NAME_UPPER}_LIB_DIR: ${${MODULE_NAME_UPPER}_LIB_DIR}" )
    message( STATUS "${MODULE_NAME_UPPER}_LIB_NAME: ${${MODULE_NAME_UPPER}_LIB_NAME}" )
endmacro()
