# Locate jsoncpp
#
# This module defines
#  JSONCPP_FOUND, if false, do not try to link to jsoncpp
#  JSONCPP_LIBRARY, where to find jsoncpp
#  JSONCPP_INCLUDE_DIR, where to find json.h
#
# By default, the dynamic libraries of jsoncpp will be found. To find the static ones instead,
# you must set the JSONCPP_STATIC_LIBRARY variable to TRUE before calling find_package(Jsoncpp ...).
#
# If jsoncpp is not installed in a standard path, you can use the JSONCPP_DIR CMake variable
# to tell CMake where jsoncpp is.

set(JSONCPP_FOUND 0)

# attempt to find static library first if this is set
if(JSONCPP_STATIC_LIBRARY)
    set(JSONCPP_STATIC libjsoncpp.a)
endif()

# find the jsoncpp include directory
find_path(JSONCPP_INCLUDE_DIR json/json.h
          PATHS
          ~/Library/Frameworks/jsoncpp/include/
          /Library/Frameworks/jsoncpp/include/
          /usr/local/include/
          /usr/include/
          /sw/jsoncpp/         # Fink
          /opt/local/jsoncpp/  # DarwinPorts
          /opt/csw/jsoncpp/    # Blastwave
          /opt/jsoncpp/
          ${JSONCPP_DIR}/include/
          PATH_SUFFIXES jsoncpp)

# find the jsoncpp library
find_library(JSONCPP_LIBRARY
             NAMES ${JSONCPP_STATIC} jsoncpp
             PATH_SUFFIXES lib64 lib
             PATHS ~/Library/Frameworks
                    /Library/Frameworks
                    /usr/local
                    /usr
                    /sw
                    /opt/local
                    /opt/csw
                    /opt
                    ${JSONCPP_DIR}/lib)

# handle the QUIETLY and REQUIRED arguments and set JSONCPP_FOUND to TRUE if all listed variables are TRUE
include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(JSONCPP DEFAULT_MSG JSONCPP_INCLUDE_DIR JSONCPP_LIBRARY)
mark_as_advanced(JSONCPP_INCLUDE_DIR JSONCPP_LIBRARY)
message("JSONCPP_FOUND = ${JSONCPP_FOUND}, includedir = ${JSONCPP_INCLUDE_DIR}, lib = ${JSONCPP_LIBRARY}")
