# DaemonBase Library

Simple C++ header only template for creating Linux daemons

### What are daemon services/processes ?
A dæmon is a program that runs silently in the background.<br>
Commonly, dæmon processes are created to offer a specific service.

**Dæmon** processes usually:
- Live for a long time;
- Started at boot time;
- Terminate only during shutdown;
- Have no controlling terminal.

[//]: # (### Dæmon Characteristics)

[//]: # (The previously listed characteristics have certain implications:)

[//]: # ()
[//]: # (- do one thing, and one thing only)

[//]: # (- resource leaks eventually surface)

[//]: # (- consider current working directory)

[//]: # (- no &#40;or only limited&#41; user-interaction possible)

[//]: # (- how to create &#40;debugging&#41; output)

### Usage
DaemonBase has a simple, straightforward api with callbacks to handle your daemon events.
```cpp
#include "daemonbase.h"
#include <cstdlib>

using namespace osdev::components::daemon;
using namespace std::chrono_literals;

class MyExampleDaemon : public DaemonBase
{
public:
    void on_start(const daemonconfig &config) override
    {
        /// Called once after daemon starts automatically with system startup 
        /// or when you manually call `$ system,ctl start MyExampleDaemon`

        /// Initialize your code here...



        daemonlog::info("MyExampleDaemon::on_start(): MyExampleDaemon version: " + config.get("version") + " started successfully!");
    }

    void on_update() override
    {
        /// Called every DURATION set in set_update_duration()...
        
        /// Update your code here

        daemonlog::info("MyExampleDaemon::on_update()");
    }

    void on_stop() override
    {
        /// Called once before daemon is about to exit with system shutdown or when you manually call `$ systemctl stop MyExampleDaemon`
        /// Cleanup your code here...

        daemonlog::info("MyExampleDaemon::on_stop()");
    }

    void on_reload(const daemonconfig &cfg) override 
    {
        /// Called once after your daemon's config fil is updated then reloaded with `$ systemctl reload MyExampleDaemon`
        /// Handle your config updates here...

        daemonlog::info("MyExampleDaemon::on_reload(): new daemon version from updated config: " + cfg.get("version"));
    }
};


int main(int argc, char *argv[])
{
    MyExampleDaemon oDaemon;                            // Create the daemon instance.

    oDaemon.set_name("MyAweSomeExampleDaemon");         // Set daemon name to identify logs in syslog
    oDaemon.set_update_duration(3s);                    // Set duration to sleep before triggering the on_update callback 3 seconds.
    oDaemon.set_cwd("/root");                           // set daemon's current working directory to roots home-folder
    oDaemon.run(argc, argv);                            // run the daemon

    return(EXIT_SUCCESS);                               // Close the main process now the child process is running.
}
```