#ifndef OSDEV_COMPONENTS_SCOPEGUARD_H
#define OSDEV_COMPONENTS_SCOPEGUARD_H

#include <functional>

namespace osdev {
namespace components {

using CleanUpFunction = std::function<void()>;

/**
 * @brief Ensures that a cleanup function is called at the end of the current scope.
 */
class ScopeGuard
{
public:

    /**
     * @brief   Constructs a RAII instance that will call cleanupFunc in it's destructor.
     * @param   cleanupFunc The cleanup function to call at the end of the current scope.
     *          This cleanup function must not throw exceptions. If it does, the behaviour
     *          is undefined.
     */
    ScopeGuard( const CleanUpFunction& cleanupFunc );

    // not copyable
    ScopeGuard( const ScopeGuard& ) = delete;
    ScopeGuard& operator=( const ScopeGuard& ) = delete;

    ~ScopeGuard() noexcept;

private:
    CleanUpFunction m_cleanupFunc;
};

}   /* End namespace components */
}   /* End namespace osdev */

#endif  /* OSDEV_COMPONENTS_SCOPEGUARD_H */
