#ifndef OSDEV_COMPONENTS_CRYPTER_H
#define OSDEV_COMPONENTS_CRYPTER_H

// std
#include <string>

namespace osdev {
namespace components {

/**
 * @brief Provides encryption/hashing functionality.
 */
class Crypter
{
public:
    /**
     * @brief Defines the encryption/hashing algorithms.
     */
    enum class AlgorithmEnum
    {
        MD0,            ///< Empty initializer.
        MD2,
        MD5,
        MDC2,
        SHA1,
        SHA224,
        SHA256,
        SHA384,
        SHA512,
        RIPEMD160
    };

    /**
     * @brief Constructs a default instance of Crypter.
     */
    Crypter();

    /**
     * @brief Encrypts the specified message using the specified algorithm.
     * @param message The message to encrypt.
     * @param algo The encryption algorithm to use. The default value is SHA256.
     * @return The encrypted string.
     */
    static std::string encrypt( const std::string& message, Crypter::AlgorithmEnum algo = Crypter::AlgorithmEnum::SHA256 );
};

}   /* End namespace components */
}   /* End namespace osdev */

#endif /* OSDEV_COMPONENTS_CRYPTER_H */
