#include "objectdata.h"

using namespace osdev::components;

ObjectData::ObjectData()
    : m_objectType()
    , m_objectId()
    , m_targetName()
    , m_targetAction()
    , m_keyField()
    , m_keyValue()
    , m_foreignKeyField()
    , m_targetField()
    , m_targetResetValue()
    , m_useNonPersistentTimestamp(false)
    , m_npTimestampBufferSize(10)
    , m_qhInputs()
    , m_qhOutputs()
{
}

void ObjectData::setObjectType(const QString& _objectType) { m_objectType = _objectType; }

void ObjectData::setObjectId(const QString& _objectId) { m_objectId = _objectId; }

void ObjectData::setTargetName(const QString& _targetName) { m_targetName = _targetName; }

void ObjectData::setTargetAction(const QString& _targetAction) { m_targetAction = _targetAction; }

void ObjectData::setKeyField(const QString& _keyField) { m_keyField = _keyField; }

void ObjectData::setKeyValue(const QString& _keyValue) { m_keyValue = _keyValue; }

void ObjectData::setForeignKeyField(const QString& foreignKeyField) { m_foreignKeyField = foreignKeyField; }

void ObjectData::setTargetField(const QString& targetField) { m_targetField = targetField; }

void ObjectData::setTargetResetValue(const QString& targetResetValue) { m_targetResetValue = targetResetValue; }

void ObjectData::setNonPersistentTimestampUsage(bool value) { m_useNonPersistentTimestamp = value; }

void ObjectData::setNonPersistentTimestampBufferSize(unsigned int value) { m_npTimestampBufferSize = value; }

const QStringList ObjectData::getInputNames() const { return m_qhInputs.keys(); }

const QString& ObjectData::getInputId(const QString& _inputName) const { return m_qhInputs.value(_inputName)->id(); }

const QString& ObjectData::getInputType(const QString& _inputName) const { return m_qhInputs.value(_inputName)->type(); }

const QString& ObjectData::getInputDefault(const QString& _inputName) const { return m_qhInputs.value(_inputName)->Default(); }

bool ObjectData::getInputExcludeFromIdentityCheck(const QString& _inputName) const { return m_qhInputs.value(_inputName)->excludeFromIdentityCheck(); }

const QStringList ObjectData::getOutputNames() const { return m_qhOutputs.keys(); }

const QString& ObjectData::getOutputType(const QString& _outputName) const { return m_qhOutputs.value(_outputName)->type(); }

const QString& ObjectData::getOutputDefault(const QString& _outputName) const { return m_qhOutputs.value(_outputName)->Default(); }

void ObjectData::setInputData(const QString& _name, const QString& _type, const QString& _id, const QString& _default, bool excludeFromIdentityCheck)
{
    // Use multiInsert in order to detect double entries at a later stage. The getters will return the last entry and in that sense the
    // behaviour is the same as when overwriting the value in the hash with an insert. The keys method used by getInputNames however will
    // return a list that holds a key multiple times if it was inserted multiple times.
    m_qhInputs.insertMulti(_name, (QSharedPointer<ConnectorData>(new ConnectorData(_name, _type, _id, _default, excludeFromIdentityCheck))));
}

void ObjectData::setOutputData(const QString& _name, const QString& _type, const QString& _default)
{
    // Use multiInsert in order to detect double entries at a later stage. The getters will return the last entry and in that sense the
    // behaviour is the same as when overwriting the value in the hash with an insert. The keys method used by getOutputNames however will
    // return a list that holds a key multiple times if it was inserted multiple times.
    m_qhOutputs.insertMulti(_name, (QSharedPointer<ConnectorData>(new ConnectorData(_name, _type, QString{}, _default)))); // no id
}
