#include "jobdata.h"

using namespace osdev::components;

JobData::JobData()
    : m_jobName()
    , m_runDate()
    , m_runTime()
    , m_interval( 0 )
    , m_targetObject()
    , m_parameters()
{
}

JobData::JobData( const QString& _jobName, const QHash<QString, QVariant>& _paramList,
                  const QTime& _runTime, const int _interval,
                  const QString &_targetObject, const QDate& _runDate )
    : m_jobName( _jobName )
    , m_runDate( _runDate )
    , m_runTime( _runTime )
    , m_interval( _interval )
    , m_targetObject( _targetObject )
    , m_parameters( _paramList )
{
}

JobData::JobData(const JobData& source )
    : m_jobName( source.jobName() )
    , m_runDate( source.runDate() )
    , m_runTime( source.runTime() )
    , m_interval( source.runInterval() )
    , m_targetObject( source.targetObject() )
    , m_parameters( source.paramList() )
{
}

JobData& JobData::operator=( const JobData& origin )
{
    if( &origin != this )
    {
        origin.copyImpl( this );
    }
    return *this;
}

void JobData::copyImpl( JobData* dest ) const
{
    dest->m_interval = m_interval;
    dest->m_targetObject = m_targetObject;
    dest->m_jobName = m_jobName;
    dest->m_parameters = m_parameters;
    dest->m_runDate = m_runDate;
    dest->m_runTime = m_runTime;
}

JobData::~JobData()
{
}

void JobData::addParameter( const QString& _varName, const QVariant &_value )
{
    m_parameters.insert( _varName, _value );
}

void JobData::setParameters( const QHash<QString, QVariant>& _paramList )
{
    // Clear the old parameter list before assigning the new parameter list. Just to be shure.
    m_parameters.clear();
    m_parameters = _paramList;
}

QVariant JobData::paramValue( const QString& _varName ) const
{
    if( m_parameters.contains( _varName ) )
    {
        return m_parameters.value( _varName );
    }

    return QVariant();
}

QStringList JobData::varNames() const
{
    return QStringList( m_parameters.keys() );
}
