#ifndef OSDEV_COMPONENTS_DCXMLETLSERVICES_H
#define OSDEV_COMPONENTS_DCXMLETLSERVICES_H

#include "dcxmlbase.h"

#include <QObject>
#include <QString>
#include <QStringList>
#include <QHash>

namespace osdev {
namespace components {
/*
 *   _________________________________________
 *  / River: "Little soul big world. Eat and  \
 *  | sleep and eat... Many souls. Very       |
 *  | straight, very simple"                  |
 *  |                                         |
 *  | Mal: "Cattle on the ship three weeks,   |
 *  | she don't go near 'em. Suddenly, we're  |
 *  | on Jiangyin and she's got a driving     |
 *  | need to commune with the beasts?"       |
 *  |                                         |
 *  | River: "They weren't cows inside. They  |
 *  | were waiting to be, but they forgot.    |
 *  | Now they see sky and they remember what |
 *  | they are."                              |
 *  |                                         |
 *  | Mal: "Is it bad that what she just said |
 *  | makes perfect sense to me?"             |
 *  |                                         |
 *  \ --Episode #5, "Safe"                    /
 *   -----------------------------------------
 *     \
 *      \
 *          .--.
 *         |o_o |
 *         |:_/ |
 *        //   \ \
 *       (|     | )
 *      /'\_   _/`\
 *      \___)=(___/
 *
 **************************************************************************************/
/*! \brief  This component locates all the services from the ModelMapper configuration.
 *          Although it can be used seperately, it is intended to be a helper class to
 *          XMLEtlConfig.
 *          While XMLEtlConfig is implemented as Singleton, this class isn't.
 */

class DcXmlEtlServices : public DcXmlBase
{
public:
    DcXmlEtlServices( const QString &fileName = QString() );

    /// Deleted copy constructor
    DcXmlEtlServices( const DcXmlEtlServices& ) = delete;

    /// Deleted assignment constructor
    DcXmlEtlServices& operator=( const DcXmlEtlServices& ) = delete;

    /// Deleted move constructor
    DcXmlEtlServices( DcXmlEtlServices&& ) = delete;

    /// Deleeted move operator
    DcXmlEtlServices& operator=( DcXmlEtlServices&& ) = delete;

    /// @brief  Loads the configuration from the given fileName.
    /// @param  fileName - The configuration file in XML format.
    virtual bool loadConfiguration( const QString &fileName );

    // =========================================================================
    /*!
     *  \brief  Get the list of services mentioned in the modelmapper configuration
     *          If no services were mentioned, this list will be empty.
     */
    QStringList getServiceNames() const;

    /*!
     *  \brief  Get the list of serviceIds mentioned in the modelmapper configuration
     *          If no ServiceIds were found, this list will be empty.
     */
    QStringList getServiceIds() const;

    /*!
     *  \brief  Get the filename of the service-configuration file.
     *          This file isn't parsed here but passed on to the DcXmlNetwork class.
     */
    QString     getServiceConfig( const QString &serviceId ) const;

    /*!
     *  \brief  Get the list of configurations by serviceId in a Hash
     *          If no services are found, this Hash will be empty.
     */
    QHash<QString, QString> getServiceConfigs() const;

    // Convenient methods.
    /*!
     * @brief   Added for convenience. The name is quite descriptive.
     */
    QString     getServiceConfigByName( const QString &serviceName ) const;
    QString     getServiceIdByName( const QString &serviceName ) const;
    QString     getServiceConfigById( const QString &serviceId ) const;

private:
    void    constructXPathHash();
    QString getValueByAttribute( const QString &XPath,
                                 const QString &attrValue,
                                 const QString &returnAttribute ) const;

};

}   /* End namespace components */
}   /* End namespace osdev */

#endif  /* OSDEV_COMPONENTS_DCXMLETLSERVICES_H */
