#include "dcxmletlservices.h"
#include "log.h"
#include <string>

using namespace osdev::components;

static const char* selectServices       = "selectServices";
static const char* selectServiceById    = "selectServiceById";
static const char* selectServiceByName  = "selectServiceByName";

DcXmlEtlServices::DcXmlEtlServices( const QString &fileName )
{
    if( !fileName.isEmpty() )
    {
        if( !loadConfiguration( fileName ) )
        {
            LogInfo( "[DcXmlEtlServices::DcXmlEtlServices]", QString( "There was an error reading file : %1" ).arg( fileName ) );
        }
    }
    else
    {
        LogInfo( "[DcXmlEtlServices::DcXmlEtlServices]", QString( "No filename given. No configuration read." ) );
    }

    constructXPathHash();
}

bool DcXmlEtlServices::loadConfiguration( const QString &fileName )
{
    return DcXmlBase::parseFile( fileName );
}

QStringList DcXmlEtlServices::getServiceNames() const
{
    QStringList lstResult;

    QList<pugi::xpath_node> serviceList = DcXmlBase::selectNodes(  DcXmlBase::getXPath( selectServices ) );
    for( const auto& nodeItem : serviceList )
    {
        lstResult.append( nodeItem.node().attribute( "name" ).value() );
    }

    return lstResult;
}

QStringList DcXmlEtlServices::getServiceIds() const
{
    QStringList lstResult;

    QList<pugi::xpath_node> serviceList = DcXmlBase::selectNodes(  DcXmlBase::getXPath( selectServices ) );
    for( const auto& nodeItem : serviceList )
    {
        lstResult.append( nodeItem.node().attribute( "id" ).value() );
    }

    return lstResult;
}

QString DcXmlEtlServices::getServiceConfig( const QString &serviceId ) const
{
    QList<QVariant> varList;
    varList.append( serviceId );

    return QString( DcXmlBase::selectNode( evaluateXPath( selectServiceById, varList ) ).node().attribute( "filename" ).value() );
}

QHash<QString, QString> DcXmlEtlServices::getServiceConfigs() const
{
    QHash<QString, QString> qhResult;

    QList<pugi::xpath_node> serviceList = DcXmlBase::selectNodes( DcXmlBase::getXPath( selectServices ) );
    for( const auto& nodeItem : serviceList )
    {
        qhResult.insert( nodeItem.node().attribute( "id" ).value(), nodeItem.node().attribute( "filename" ).value() );
    }

    return qhResult;
}

void DcXmlEtlServices::constructXPathHash()
{
    DcXmlBase::addXPath( selectServices,        "//modelmapping/services/service" );
    DcXmlBase::addXPath( selectServiceById,     "//modelmapping/services/service[@id='%1']" );
    DcXmlBase::addXPath( selectServiceByName,   "//modelmapping/services/service[@name='%1']" );
}

QString DcXmlEtlServices::getServiceConfigByName( const QString &serviceName ) const
{
    return this->getValueByAttribute( selectServiceByName, serviceName, "filename" );
}

QString DcXmlEtlServices::getServiceIdByName( const QString &serviceName ) const
{
    return this->getValueByAttribute( selectServiceByName, serviceName, "id" );
}

QString DcXmlEtlServices::getServiceConfigById( const QString &serviceId ) const
{
    return this->getValueByAttribute( selectServiceById, serviceId, "filename" );
}

QString DcXmlEtlServices::getValueByAttribute( const QString &XPath,
                                               const QString &attrValue,
                                               const QString &returnAttribute ) const
{
    QList<QVariant> varList;
    varList.append( attrValue );

    return QString( DcXmlBase::selectNode( evaluateXPath( XPath.toStdString().c_str(), varList ) ).node().attribute( returnAttribute.toStdString().c_str() ).value() );
}
