#ifndef OSDEV_COMPONENTS_DCXMLETLNETWORK_H
#define OSDEV_COMPONENTS_DCXMLETLNETWORK_H

#include "connection.h"
#include "connections.h"
#include "connectordata.h"
#include "dcxmlbase.h"
#include "objectdata.h"

// Qt
#include <QHash>
#include <QList>
#include <QSharedPointer>
#include <QString>
#include <QStringList>
#include <QThread>

namespace osdev {
namespace components {

/*
 *   _________________________________________
 *  / An expert is one who knows more and     \
 *  | more about less and less until he knows |
 *  \ absolutely everything about nothing.    /
 *   -----------------------------------------
 *     \
 *      \
 *          .--.
 *         |o_o |
 *         |:_/ |
 *        //   \ \
 *       (|     | )
 *      /'\_   _/`\
 *      \___)=(___/
 *******************************************************/
/*!
 *  \brief  The class that actually parses the configuration file and provides
 *          accessors to the internal data.
 */
class DcXmlEtlNetwork : public DcXmlBase
{
public:
    DcXmlEtlNetwork();
    explicit DcXmlEtlNetwork(const QString& fileName);
    virtual ~DcXmlEtlNetwork();

    QStringList getNetworkNames() const;
    QList<QSharedPointer<ObjectData>> getObjectsOfNetwork(const QString& networkName) const;
    Connections getConnectionsOfNetwork(const QString& networkName) const;

    QStringList getInputVariables(const QString& serviceName) const;
    QStringList getOutputVariables(const QString& networkName) const;

    QThread::Priority getPrioByNetworkName(const QString& networkName) const;

private:
    void constructXPathHash();
    void constructEnumHash();

    QHash<QString, QThread::Priority> m_qhPriority; // Enum from QThread
};

} // namespace components
} // namespace osdev

#endif // OSDEV_COMPONENTS_DCXMLETLNETWORK_H
