﻿#ifndef OSDEV_COMPONENTS_DCXMLDAL_H
#define OSDEV_COMPONENTS_DCXMLDAL_H

#include <QHash>
#include <QString>

#include "dcxmlbase.h"
#include "log.h"
#include "memory"

namespace osdev     {
namespace components {

/*!
 * \brief The DcXmlDal class
 * Reads data from the configuration and makes it easily accessible
 */
class DcXmlDal : public DcXmlBase
{
public:
    /// @return the one and only instance of the config object.
    static DcXmlDal& Instance();

    /// The constructor
    DcXmlDal( const QString &fileName = QString() );

    /// The destructor
    virtual ~DcXmlDal();

    /// Deleted copy-constructor
    DcXmlDal( const DcXmlDal& ) = delete;
    /// Deleted assignment constructor
    DcXmlDal& operator=( const DcXmlDal& ) = delete;
    /// Deleted move-constructor
    DcXmlDal( DcXmlDal&& ) = delete;
    /// Deleted move-operator
    DcXmlDal& operator=( DcXmlDal&& ) = delete;
    // ==========================================================

    /*!
     * \brief loadConfiguration - This function loads the xml file into memory
     * \param configDir         - configuration directory
     * \param fileName          - configuration file name
     * \return true if succeeded
     */
    bool loadConfiguration( const QString &configDir, const QString &fileName );
    /*!
     * \brief loadConfiguration - This function loads the xml file into memory
     * \param fileName          - configuration file name
     * \return true if succeeded
     */
    bool loadConfiguration( const QString &fileName );

    /*!
     * \brief constructXPathHash - This function initializes all XML XPaths
     */
    void constructXPathHash();

    /*!
     * \brief getQueries        - This function fetches all function names from the config
     * \return a list of function names received from the config
     */
    QStringList getQueries() const;
    /*!
     * \brief getQueryByName    - This function returns the value of the requested function name
     * \param _queryName        - function name to look up
     * \return the value matching to the function name
     */
    QString getQueryByName( const QString &_queryName ) const;

private:
    static std::unique_ptr<DcXmlDal>    s_instance; ///< Singleton pointer
};

}   /* end namespace components */
}   /* end namespace osdev  */

#endif // OSDEV_COMPONENTS_DCXMLDAL_H
