#include "dcxmldal.h"
#include "dcxmlconfig.h"

using namespace osdev::components;

static const char* selectFunctions          = "selectFunctions";        // return all functions
static const char* selectFunctionByName     = "selectFunction";         // return function by command name

// The only instance of the singleton Dal Config Parser.
std::unique_ptr<DcXmlDal>  DcXmlDal::s_instance( nullptr );

DcXmlDal& DcXmlDal::Instance()
{
    if( nullptr == s_instance )
    {
        s_instance = std::unique_ptr<DcXmlDal>( new DcXmlDal( DCXmlConfig::Instance().getDalConfig() ) );
    }

    return *s_instance;
}

DcXmlDal::DcXmlDal( const QString &fileName )
{
    if( !fileName.isEmpty() )
    {
        if( !loadConfiguration( fileName ) )
        {
            LogWarning( "[DcXmlDal::DcXmlDal]", QString( "There was an error reading file : %1" ).arg( fileName ) );
        }
    }
    else
    {
        LogWarning( "[DcXmlDal::DcXmlDal]", QString( "No filename given. No configuration read." ) );
    }

    constructXPathHash();
}

DcXmlDal::~DcXmlDal()
{
}

bool DcXmlDal::loadConfiguration( const QString &fileName )
{
    return loadConfiguration( DCXmlConfig::Instance().getConfigPath(), fileName );
}

bool DcXmlDal::loadConfiguration( const QString &configDir, const QString &fileName )
{
    return DcXmlBase::parseFile( configDir + fileName );
}

void DcXmlDal::constructXPathHash()
{
    DcXmlBase::addXPath( selectFunctions        , "//data_access/functions/function" );
    DcXmlBase::addXPath( selectFunctionByName   , "//data_access/functions/function[@name='%1']" );
}

QStringList DcXmlDal::getQueries() const
{
    QStringList lstResult;

    QList<pugi::xpath_node> functionList = DcXmlBase::selectNodes(  DcXmlBase::getXPath( selectFunctions ) );
    for( const auto& nodeItem : functionList )
    {
        lstResult.append( nodeItem.node().attribute( "name" ).value() );
    }

    return lstResult;
}

QString DcXmlDal::getQueryByName( const QString &_queryName ) const
{
    QList<QVariant> varList;
    varList.append( _queryName );

    return QString( DcXmlBase::selectNode( evaluateXPath( selectFunctionByName, varList ) ).node().attribute( "value" ).value() );
}
