#include "dcxmlconfig.h"
#include "log.h"

#include <QtDebug>

using namespace osdev::components;

static const char* selectPluginPath             = "selectPluginPath";
static const char* selectConfigPath             = "selectConfigPath";
static const char* selectIniFile                = "selectIniFile";
static const char* selectLogPath                = "selectLogPath";
static const char* selectSslPath                = "selectSslPath";
static const char* selectPlugins                = "selectPlugins";
static const char* selectDbCreds                = "selectDbCreds";
static const char* selectDbUserName             = "selectDbUserName";
static const char* selectDbPassWord             = "selectDbPassWord";
static const char* selectDbName                 = "selectDbName";
static const char* selectDbType                 = "selectDbType";
static const char* selectDbIdentifier           = "selectDbIdentifier";
static const char* selectDbWdEnable             = "selectDbWdEnabled";
static const char* selectDbWdInterval           = "selectDbWdInterval";
static const char* selectLogFile                = "selectLogFile";
static const char* selectLogLevel               = "selectLogLevel";
static const char* selectModelMapConfig         = "selectModelMapConfig";
static const char* selectLogQueueSizeIntervalSecs = "selectLogQueueSizeIntervalSecs";
static const char* selectOrmTables              = "selectOrmTables";
static const char* selectRecTrackField          = "selectRecTrackField";
static const char* selectGustavJung             = "selectGustavJung";
// static const char* selectPluginMaxThreads       = "selectPluginMaxThreads";
static const char* selectEventLogging           = "selectEventLogging";
static const char* selectTTL                    = "selectTTL";
static const char* selectTransLogPath           = "selectTransLogPath";
static const char* selectJobs                   = "selectJobs";
static const char* selectJobSettings            = "selectJobSettings";
static const char* selectJobParameters          = "selectJobParameters";
static const char* selectLogIpAddress           = "selectLogIpAddress";
static const char* selectLogPortNum             = "selectLogPortNum";
static const char* selectIpAddress              = "selectIpAddress";
static const char* selectPortNumber             = "selectPortNumber";
static const char* selectSslCert                = "selectSslCert";
static const char* selectSslKey                 = "selectSslKey";
static const char* selectSslCaCert              = "selectSslCaCert";
static const char* selectSslProtocol            = "selectSslProtocol";

/* Sensor Settings */
static const char* selectSensorProtocol         = "selectSensorProtocol";
static const char* selectSensorCache            = "selectSensorCache";
static const char* selectSensorServerHost       = "selectSensorServerHost";
static const char* selectSensorServerPort       = "selectSensorServerPort";
static const char* selectSensorTopics           = "selectSensorTopics";

static const char* selectTranslatorConfigPath   = "selectTranslatorConfigPath";
static const char* selectTranslatorConfigFile   = "selectTranslatorConfigFile";
static const char* selectDatarateDirect         = "selectDatarateDirect";
static const char* selectDatarateTimed          = "selectDatarateTimed";

static const char* selectDalConfig              = "selectDalConfig";

// The only instance of the singleton config parser.
std::unique_ptr<DCXmlConfig> DCXmlConfig::s_instance( nullptr );

DCXmlConfig::DCXmlConfig()
    : m_qhDbHash()
{
    constructXPathHash();
    constructEnumHashes();
}

DCXmlConfig& DCXmlConfig::Instance()
{
    if( nullptr == s_instance )
    {
        s_instance = std::unique_ptr<DCXmlConfig>( new DCXmlConfig() );
    }

    return *s_instance;
}

bool DCXmlConfig::loadConfiguration( const QString& fileName )
{
    return DcXmlBase::parseFile( fileName );
}

QStringList DCXmlConfig::getPluginPaths() const
{
    QStringList pathList;
    for (const auto& pathNode : DcXmlBase::selectNodes( DcXmlBase::getXPath( selectPluginPath ) ))
    {
        pathList.append(pathNode.node().attribute("value").value());
    }
    return pathList;
}

QStringList DCXmlConfig::getPlugins() const
{
    QStringList pluginList;

    QList<pugi::xpath_node> selectedNodes = DcXmlBase::selectNodes( DcXmlBase::getXPath( selectPlugins ) );
    for ( auto& nodeItem : selectedNodes )
    {
        pluginList.append( nodeItem.node().attribute( "value" ).value() );
    }

    return pluginList;
}

QStringList DCXmlConfig::getOrmTables() const
{
    QStringList tableList;

    QList<pugi::xpath_node> selectedNodes = DcXmlBase::selectNodes( DcXmlBase::getXPath( selectOrmTables ) );
    for( auto& nodeItem : selectedNodes )
    {
        tableList.append( nodeItem.node().attribute("value").value() );
    }

    return tableList;
}

QList<JobData> DCXmlConfig::getScheduledJobs() const
{
    QList<JobData> lstResult;

    QList<pugi::xpath_node> jobList = DcXmlBase::selectNodes( DcXmlBase::getXPath( selectJobs ) );
    for( auto& jobItem : jobList )
    {
        // Create a new JobData object for each job.
        JobData oJob;
        oJob.setJobName(jobItem.node().attribute("jobname").value());

        // Get settings for the current Job.
        QList<QVariant> varList;
        varList.append( oJob.jobName() );
        QList<pugi::xpath_node> jobSettings = DcXmlBase::selectNodes( DcXmlBase::evaluateXPath( selectJobSettings, varList ) );
        for (auto& jobSetting : jobSettings) {
            // Attribute querying not supported in 1.0.x. Only from 1.7 and up. We have to do it the "dumb"-way.
            if (!QString(jobSetting.node().attribute("date").value()).isEmpty()) {
                oJob.setRunDate(QDate::fromString(QString(jobSetting.node().attribute("date").value()), QString("dd-MM-yyyy")));
            }

            if( QString( jobSetting.node().attribute( "name" ).value() ) == "date" )
            {
                oJob.setRunDate( QDate::fromString( QString( jobSetting.node().attribute( "value" ).value() ), QString( "dd-MM-yyyy" ) ) );
            }

            if( QString( jobSetting.node().attribute( "name" ).value() ) == "time" )
            {
                oJob.setRunTime( QTime::fromString( QString( jobSetting.node().attribute( "value" ).value() ), QString( "hh:mm:ss" ) ) );
            }

            if( QString( jobSetting.node().attribute( "name" ).value() ) == "interval" )
            {
                oJob.setRunInterval( QString( jobSetting.node().attribute( "value" ).value() ).toInt() );
            }
        }

        // Get all parameters of this job and add them to the jobData object
        QList<pugi::xpath_node> jobParameters = DcXmlBase::selectNodes( DcXmlBase::evaluateXPath( selectJobParameters, varList ) );
        for( auto& jobParameter : jobParameters )
        {
            oJob.addParameter( jobParameter.node().attribute( "name" ).value(), QVariant( QString( jobParameter.node().attribute( "value" ).value() ) ) );
        }

        // If arrived here, we have all data from this job. Store the result.
        lstResult.append( oJob );
    }

    return lstResult;
}

bool DCXmlConfig::mqttDirectEnabled() const
{
    if (QString(DcXmlBase::selectNode(DcXmlBase::getXPath(selectDatarateDirect)).node().attribute("enabled").value()) == "1")
        return true;

    return false;
}

int DCXmlConfig::mqttTimedInterval() const
{
    return DcXmlBase::selectNode(DcXmlBase::getXPath(selectDatarateTimed)).node().attribute("interval").as_int();
}

QString DCXmlConfig::getRecordTrackFieldName() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectRecTrackField ) ).node().attribute( "value" ).value();
}

QHash<DCXmlConfig::eDbSettings, QString> DCXmlConfig::getDbCredentials() const
{
    return this->getServiceSettings<DCXmlConfig::eDbSettings, eDbUnknown>(selectDbCreds, m_qhDbHash);
}

bool DCXmlConfig::getEnableDbWatchDog() const
{
    return getBoolean( DcXmlBase::selectNode( DcXmlBase::getXPath( selectDbWdEnable ) ).node().attribute("value").value() );
}

int DCXmlConfig::getDbCheckInterval() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectDbWdInterval ) ).node().attribute("value").as_int();
}

QString DCXmlConfig::getLogPath() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectLogPath ) ).node().attribute("value").value();
}

QString DCXmlConfig::getLogFile() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectLogFile ) ).node().attribute("value").value();
}

QString DCXmlConfig::getIniFile() const
{
    auto iniFile = DcXmlBase::selectNode( DcXmlBase::getXPath( selectIniFile ) ).node().attribute("value").value();
    return getConfigPath() + "/" + iniFile;
}

QString DCXmlConfig::getLogLevel() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectLogLevel ) ).node().attribute("value").value();
}

QString DCXmlConfig::getModelMapConfig() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectModelMapConfig ) ).node().attribute("value").value();
}

QString DCXmlConfig::getDalConfig() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectDalConfig ) ).node().attribute("value").value();
}

QString DCXmlConfig::getConfigPath() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectConfigPath ) ).node().attribute("value").value();
}

QString DCXmlConfig::getLogIpAddress() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectLogIpAddress ) ).node().attribute( "value" ).value();
}

int DCXmlConfig::getLogPortNum() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectLogPortNum ) ).node().attribute( "value" ).as_int();
}

QString DCXmlConfig::getIpAddress() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectIpAddress ) ).node().attribute("value").value();
}

int DCXmlConfig::getPortNumber() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectPortNumber ) ).node().attribute("value").as_int();
}

QString DCXmlConfig::getSslPath() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectSslPath ) ).node().attribute("value").value();
}

QString DCXmlConfig::getSslCert() const
{
    return ( this->getSslPath() + DcXmlBase::selectNode( DcXmlBase::getXPath( selectSslCert ) ).node().attribute("value").value() );
}

QString DCXmlConfig::getSslKey() const
{
    return ( this->getSslPath() + DcXmlBase::selectNode( DcXmlBase::getXPath( selectSslKey ) ).node().attribute("value").value() );
}

QString DCXmlConfig::getSslCaCert() const
{
    return ( this->getSslPath() + DcXmlBase::selectNode( DcXmlBase::getXPath( selectSslCaCert ) ).node().attribute("value").value() );
}

QString DCXmlConfig::getSslProtocol() const
{
    return ( this->getSslPath() + DcXmlBase::selectNode( DcXmlBase::getXPath( selectSslProtocol ) ).node().attribute("value").value() );
}

QString DCXmlConfig::transactionPath() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectTransLogPath ) ).node().attribute("value").value();
}

int DCXmlConfig::timeToLive() const
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectTTL ) ).node().attribute("value").as_int();
}
// ===========================================================================================================================================
// Sensor Settings Co2Mos
// -------------------------------------------------------------------------------------------------------------------------------------------
QString DCXmlConfig::getSensorProtocol()
{
    return DcXmlBase::selectNode(DcXmlBase::getXPath( selectSensorProtocol ) ).node().attribute( "value" ).value();
}

bool DCXmlConfig::getSensorCache()
{
    return getBoolean( DcXmlBase::selectNode( DcXmlBase::getXPath( selectSensorCache ) ).node().attribute("value").value() );
}

QString DCXmlConfig::getSensorServerHost()
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectSensorServerHost ) ).node().attribute( "value" ).value();
}

int DCXmlConfig::getSensorServerPort()
{
    return DcXmlBase::selectNode( DcXmlBase::getXPath( selectSensorServerPort ) ).node().attribute( "value" ).as_int();
}

QStringList DCXmlConfig::getSensorTopicList()
{
    QStringList l_result;

    QList<pugi::xpath_node> node_list = DcXmlBase::selectNodes( DcXmlBase::getXPath( selectSensorTopics ) );
    for( const auto& topic_node : node_list )
    {
        l_result.append( topic_node.node().attribute( "value" ).value() );
    }

    return l_result;
}

// ===========================================================================================================================================
void DCXmlConfig::constructXPathHash()
{
    // Generic Paths
    DcXmlBase::addXPath( selectConfigPath   , "//configuration/context[@name='global']/context[@name='paths']/setting[@name='configpath']" );
    DcXmlBase::addXPath( selectIniFile      , "//configuration/context[@name='global']/context[@name='paths']/setting[@name='inifile']" );
    DcXmlBase::addXPath( selectLogPath      , "//configuration/context[@name='global']/context[@name='paths']/setting[@name='logpath']" );
    DcXmlBase::addXPath( selectSslPath      , "//configuration/context[@name='global']/context[@name='paths']/setting[@name='sslpath']" );

    // Plugin SettingsePmsServiceName
    DcXmlBase::addXPath( selectPluginPath   , "//configuration/context[@name='global']/context[@name='paths']/setting[@name='pluginpath']" );
    DcXmlBase::addXPath( selectPlugins      , "//configuration/context[@name='global']/context[@name='plugins']/setting" );

    // Database Settings
    DcXmlBase::addXPath( selectDbCreds      , "//configuration/context[@name='global']/context[@name='database']/setting" );
    DcXmlBase::addXPath( selectDbUserName   , "//configuration/context[@name='global']/context[@name='database']/setting[@name='username']" );
    DcXmlBase::addXPath( selectDbPassWord   , "//configuration/context[@name='global']/context[@name='database']/setting[@name='password']" );
    DcXmlBase::addXPath( selectDbName       , "//configuration/context[@name='global']/context[@name='database']/setting[@name='dbName']" );
    DcXmlBase::addXPath( selectDbType       , "//configuration/context[@name='global']/context[@name='database']/setting[@name='dbtype']" );
    DcXmlBase::addXPath( selectDbIdentifier , "//configuration/context[@name='global']/context[@name='database']/setting[@name='identifier']" );
    DcXmlBase::addXPath( selectDbWdEnable   , "//configuration/context[@name='global']/context[@name='database']/watchdog/setting[@name='enabled']" );
    DcXmlBase::addXPath( selectDbWdInterval , "//configuration/context[@name='global']/context[@name='database']/watchdog/setting[@name='interval']" );

    // ORM Settings
    DcXmlBase::addXPath( selectOrmTables    , "//configuration/context[@name='orm']/context[@name='tables']/setting" );
    DcXmlBase::addXPath( selectRecTrackField, "//configuration/context[@name='orm']/context[@name='record_tracking']/setting" );

    // Transaction Queue Settings
    DcXmlBase::addXPath( selectTTL          , "//configuration/context[@name='transqueue']/setting[@name='ttl']" );
    DcXmlBase::addXPath( selectTransLogPath , "//configuration/context[@name='transqueue']/setting[@name='transaction_logs']" );

    // System SettingsePmsServiceName
    DcXmlBase::addXPath( selectGustavJung   , "//configuration/context[@name='global']/context[@name='system']/setting[@name='synchronicity']" );
//    DcXmlBase::addXPath( selectPluginMaxThreads, "//configuration/context[@name='global']/context[@name='system']/setting[@name='plugin_max_threads']" );
    DcXmlBase::addXPath( selectEventLogging , "//configuration/context[@name='global']/context[@name='logging']/setting[@name='event_logging']" );
    DcXmlBase::addXPath( selectLogFile      , "//configuration/context[@name='global']/context[@name='logging']/setting[@name='log_file']" );
    DcXmlBase::addXPath( selectLogLevel     , "//configuration/context[@name='global']/context[@name='logging']/setting[@name='log_level']" );
    DcXmlBase::addXPath(selectLogQueueSizeIntervalSecs, "//configuration/context[@name='global']/context[@name='logging']/setting[@name='queue_size_interval_secs']");

    // Modelmapper Settings
    DcXmlBase::addXPath( selectModelMapConfig, "//configuration/context[@name='modelmapper']/context[@name='modelmapping']/setting[@name='modelmapconfig']" );

    // Jobscheduler settings
    DcXmlBase::addXPath( selectJobs         , "//configuration/context[@name='jobscheduler']/jobs/job" );
    DcXmlBase::addXPath( selectJobSettings  , "//configuration/context[@name='jobscheduler']/jobs/job[@name='%1']/settings/setting" );
    DcXmlBase::addXPath( selectJobParameters, "//configuration/context[@name='jobscheduler']/jobs/job[@name='%1']/parameters/parameter" );

    // EqMqtt Config settings
    DcXmlBase::addXPath(selectTranslatorConfigPath, "//configuration/context[@name='eqmqtt']/context[@name='translation']/setting[@name='translate_path']");
    DcXmlBase::addXPath(selectTranslatorConfigFile, "//configuration/context[@name='eqmqtt']/context[@name='translation']/setting[@name='translate_file']");
    DcXmlBase::addXPath(selectDatarateDirect, "//configuration/context[@name='eqmqtt']/context[@name='datarate']/setting[@name='direct']");
    DcXmlBase::addXPath(selectDatarateTimed, "//configuration/context[@name='eqmqtt']/context[@name='datarate']/setting[@name='timed']");

    // Remote Log Viewer / server
    DcXmlBase::addXPath( selectLogIpAddress , "//configuration/context[@name='logprocessor']/setting[@name='ip-address']" );
    DcXmlBase::addXPath( selectLogPortNum   , "//configuration/context[@name='logprocessor']/setting[@name='port']"     );

    // MedCow settings
    DcXmlBase::addXPath( selectIpAddress    , "//configuration/context[@name='network']/setting[@name='ip_address']"    );
    DcXmlBase::addXPath( selectPortNumber   , "//configuration/context[@name='network']/setting[@name='port_no']"       );
    DcXmlBase::addXPath( selectSslCert      , "//configuration/context[@name='network']/setting[@name='ssl_cert']"      );
    DcXmlBase::addXPath( selectSslKey       , "//configuration/context[@name='network']/setting[@name='ssl_key']"       );
    DcXmlBase::addXPath( selectSslCaCert    , "//configuration/context[@name='network']/setting[@name='ssl_ca']"        );
    DcXmlBase::addXPath( selectSslProtocol  , "//configuration/context[@name='network']/setting[@name='ssl_protocol']"  );

    // Dal settings
    DcXmlBase::addXPath( selectDalConfig    , "//configuration/context[@name='dal']/context[@name='data_access']/setting[@name='dalconfig']" );

    // Sensor Settings
    DcXmlBase::addXPath( selectSensorProtocol   , "//configuration/context[@name='sensors']/setting[@name='protocol']" );
    DcXmlBase::addXPath( selectSensorCache      , "//configuration/context[@name='sensors']/setting[@name='cached']" );
    DcXmlBase::addXPath( selectSensorServerHost , "//configuration/context[@name='sensors']/setting[@name='serverhost']" );
    DcXmlBase::addXPath( selectSensorServerPort , "//configuration/context[@name='sensors']/setting[@name='serverport']" );
    DcXmlBase::addXPath( selectSensorTopics     , "//configuration/context[@name='sensors']/topics/topic" );

    // Dal settings
    DcXmlBase::addXPath( selectDalConfig    , "//configuration/context[@name='dal']/context[@name='data_access']/setting[@name='dalconfig']" );
}

void DCXmlConfig::constructEnumHashes()
{
    // Build the Db Translator Hash
    m_qhDbHash.insert( "username", eDbSettings::eDbUsername );
    m_qhDbHash.insert( "password", eDbSettings::eDbPassword );
    m_qhDbHash.insert( "dbname", eDbSettings::eDbName );
    m_qhDbHash.insert( "hostname", eDbSettings::eDbHostName );
    m_qhDbHash.insert( "identifier", eDbSettings::eDbIdentifier );
    m_qhDbHash.insert( "dbtype", eDbSettings::eDbType );
}

bool DCXmlConfig::getEventLogging() const
{
    bool b_result = false;

    b_result = getBoolean( DcXmlBase::selectNode( DcXmlBase::getXPath( selectEventLogging ) ).node().attribute("value").value() );

    return b_result;
}

bool DCXmlConfig::getSynchronicity() const
{
    bool b_result = false;

    b_result = getBoolean( DcXmlBase::selectNode( DcXmlBase::getXPath( selectGustavJung ) ).node().attribute("value").value() );

    return b_result;
}

int DCXmlConfig::getLogQueueSizeIntervalSecs() const
{
    return DcXmlBase::selectNode(DcXmlBase::getXPath(selectLogQueueSizeIntervalSecs)).node().attribute("value").as_int();
}

bool DCXmlConfig::getBoolean( const QVariant& value ) const
{
    bool b_result = false;

    QString l_result = value.toString().toUpper();
    if ( // ------------------------
         ( "Y"      == l_result ) ||
         ( "YES"    == l_result ) ||
         ( "TRUE"   == l_result ) ||
         ( "ON"     == l_result ) ||
         ( "1"      == l_result )
         // ------------------------
       )
    {
        b_result = true;
    }

    return b_result;
}
