#pragma once

#include <string>

namespace osdev {
namespace components {

/*  ______________________________________
 * / It's hard to think of you as the end \
 * | result of millions of years of       |
 * \ evolution.                           /
 *  --------------------------------------
 *   \
 *    \
 *        .--.
 *       |o_o |
 *       |:_/ |
 *      //   \ \
 *     (|     | )
 *    /'\_   _/`\
 *    \___)=(___/
 ********************************************
 */
/*!
 * \brief The ConnectorData class
 */

class ConnectorData
{
public:
    /*!
     * \brief ConnectorData
     */
    ConnectorData();

    /*!
     * \brief ConnectorData
     * \param name The name of the ConnectorData.
     * \param type The type of the ConnectorData.
     * \param id The id of the ConnectorData.
     * \param defaultValue The default of the ConnectorData.
     * \param excludeFromIdentityCheck Flag that indicates if this variable should participate in a record identity check. Default false.
     */
    ConnectorData(const std::string& name, const std::string& type, const std::string& id, const string& defaultValue, bool excludeFromIdentityCheck = false);

    /*!
     * \brief setName
     * \param name The name of the ConnectorData.
     */
    void setName(const std::string& name);

    /*!
     * \brief setType
     * \param type The type of the ConnectorData.
     */
    void setType(const std::string& type);

    /*!
     * \brief setId
     * \param id The id of the ConnectorData.
     */
    void setId(const std::string& id);

    /*!
     * \brief setDefault
     * \param defaultValue The default of the ConnectorData.
     */
    void setDefault(const std::string& defaultValue);

    /*!
     * \brief set excludeFromIdentityCheck flag value
     * \param value The excludeFromIdentityCheck flag value of the ConnectorData.
     */
    void setExcludeFromIdentityCheck(bool value);

    /*!
     * \return The name of the ConnectorData.
     */
    const std::string& name() const { return m_name; }

    /*!
     * \return The type of the ConnectorData.
     */
    const std::string& type() const { return m_type; }

    /*!
     * \return The id of the ConnectorData. A null string means that there is no id.
     */
    const std::string& id() const { return m_id; }

    /*!
     * \return default The default of the ConnectorData.
     */
    const std::string& Default() const { return m_default; }

    /*!
     * \return the excludeFromIdentityCheck flag
     */
    bool excludeFromIdentityCheck() const { return m_excludeFromIdentityCheck; }

private:
    std::string m_name;                  ///< The name of the variable this connector represents.
    std::string m_type;                  ///< The type of the variable this connector represents.
    std::string m_id;                    ///< The id of the variable this connector represents.
    std::string m_default;               ///< The default value of the variable this connector represents.
    bool m_excludeFromIdentityCheck;     ///< Flag that indicates if this variable should participate in a record identity check.
};

} // namespace components
} // namespace osdev
