#include "connectordata.h"

using namespace osdev::components;

ConnectorData::ConnectorData()
    : m_name()
    , m_type()
    , m_id()
    , m_default()
    , m_excludeFromIdentityCheck(false)
{
}

ConnectorData::ConnectorData(const QString& _name, const QString& _type, const QString& _id, const QString& _default, bool _excludeFromIdentityCheck)
    : m_name(_name)
    , m_type(_type)
    , m_id(_id)
    , m_default(_default)
    , m_excludeFromIdentityCheck(_excludeFromIdentityCheck)
{
}

void ConnectorData::setName(const QString& _name) { m_name = _name; }

void ConnectorData::setType(const QString& _type) { m_type = _type; }

void ConnectorData::setId(const QString& _id) { m_id = _id; }

void ConnectorData::setDefault(const QString& _default) { m_default = _default; }

void ConnectorData::setExcludeFromIdentityCheck(bool value) { m_excludeFromIdentityCheck = value; }
