#pragma once

#include "connection.h"

#include <QList>
#include <QSharedPointer>
#include <string>
#include <memory>
#include <vector>

namespace osdev {
namespace components {

/*
 *  ______________________________________
 * / My opinions always matter :-)        \
 * |                                      |
 * | - Dan Malek on the linuxppc-embedded |
 * \ list                                 /
 *  --------------------------------------
 *    \
 *     \
 *         .--.
 *        |o_o |
 *        |:_/ |
 *       //   \ \
 *      (|     | )
 *     /'\_   _/`\
 *     \___)=(___/
 *******************************************
 */
/*!
 * \brief The connections class contains the source- and target
 *        endpoints of function-block connections. In- and outputs
 *        are represented by endpoint objects to be able to translate
 *        those to standard signals and slots.
 */

class Connections
{
public:
    /*!
     * \brief CTor
     */
    Connections();

    /*!
     * \brief addConnection - Probably adds a connection...
     * \param _source   - The object we want to connect from by UUId
     * \param _target   - The object we want to connect to by UUId
     * \param _output   - The endpoint on the SOURCE by Name
     * \param _input    - The endpoint on the TARGET by Name
     */
    void addConnection(const std::string& _source, const std::string& _target, const std::string& _output, const std::string& _input);

    /*!
     * \return  The number of connections stored.
     */
    int count() const { return m_connections.size(); }

    /*!
     * \brief Gets the Connection for the specified index.
     * \param index The index for the connection.
     * \return Shared pointer to the connection.
     */
    std::shared_ptr<Connection> getConnection(int index);

    /*!
     * \brief Get the connections.
     * \return A list of connection shared pointers.
     */
    std::vector<std::shared_ptr<Connection>> getConnections() const { return m_connections; }

private:
    std::vector<std::shared_ptr<Connection>>    m_connections;
};

} // namespace components
} // namespace osdev
