#include "connections.h"

using namespace osdev::components;

Connections::Connections()
    : m_connections()
{
}

void Connections::addConnection(const QString& _source, const QString& _target, const QString& _output, const QString& _input)
{
    m_connections.append(QSharedPointer<Connection>(new Connection(_source, _target, _output, _input)));
}

QSharedPointer<Connection> Connections::getConnection(int index)
{
    if (index < m_connections.count()) {
        return m_connections.at(index);
    }
    return QSharedPointer<Connection>();
}
