#pragma once

#include <string>

namespace osdev {
namespace components {

/*
 *   _________________________________________
 *  / In a hierarchy every employee tends to  \
 *  | rise to his level of incompetence ...   |
 *  | in time every post tends to be occupied |
 *  | by an employee who is incompetent to    |
 *  | carry out its duties ... Work is        |
 *  | accomplished by those employees who     |
 *  | have not yet reached their level of     |
 *  | incompetence.                           |
 *  |                                         |
 *  | -- Dr. Laurence J. Peter, "The Peter    |
 *  \ Principle"                              /
 *   -----------------------------------------
 *     \
 *      \
 *          .--.
 *         |o_o |
 *         |:_/ |
 *        //   \ \
 *       (|     | )
 *      /'\_   _/`\
 *      \___)=(___/
 ***********************************************
 */
/*!
 * \brief The Connection class is a representation of the connection section in the Modelmapper configurator
 */
class Connection
{
public:
    Connection();
    /*!
     * \brief CTor
     * \param _source   - The object we want to connect from
     * \param _target   - The object we want to connect to
     * \param _output   - The endpoint on the SOURCE
     * \param _input    - The endpoint on the TARGET
     */
    Connection(const std::string& _source, const std::string& _target, const std::string& _output, const std::string& _input);

    // GETTERS
    /*!
     * \brief source
     * \return The object-ID we want to connect from as std::string
     */
    const std::string& source() const { return m_source; }

    /*!
     * \brief target
     * \return The object-ID we want to connect to as std::string
     */
    const std::string& target() const { return m_target; }

    /*!
     * \brief output
     * \return The output endpoint on the Source object
     */
    const std::string& output() const { return m_output; }

    /*!
     * \brief input
     * \return The input endpoint on the Target object.
     */
    const std::string& input() const { return m_input; }

private:
    std::string m_source; ///< The object we want to connect from
    std::string m_target; ///< The object we want to connect to
    std::string m_input;  ///< The endpoint ont the SOURCE
    std::string m_output; ///< The endpoint ont the TARGET
};

} // namespace components
} // namespace osdev

