# @brief Creates the qt5 ui_ headers for the specified designer files.
# @param SRC_LIST The current source list of the project, to which to add the created moc files.
# @param UIC_LIST The list of designer files for which to create qt5 headers.
macro(create_ui SRC_LIST UIC_LIST)

message( STATUS "${PROJECT_NAME} Creating headers for: ${ARGN}")

set( UICABLE_LIST
    ${ARGN}
)

# Empty the UIC_LIST variable
set( ${UIC_LIST}
)

# Create the UIC_LIST
QT5_WRAP_UI( ${UIC_LIST} ${UICABLE_LIST} )

# Append SRC_LIST with UIC_LIST
list ( APPEND SRC_LIST
    ${${UIC_LIST}}
)

# Avoid warnings by including a generated header file.
include_directories( ${SYSTEMORNOT} 
    ${CMAKE_CURRENT_BINARY_DIR} 
    ${CMAKE_SOURCE_DIR}
)

message( STATUS "${PROJECT_NAME} UIC_LIST: ${${UIC_LIST}}")
message( STATUS "${PROJECT_NAME} SRC_LIST: ${${SRC_LIST}}")

set_source_files_properties(
    ${${UIC_LIST}}
    PROPERTIES
        COMPILE_FLAGS -Wno-undefined-reinterpret-cast
)

endmacro()
