# @brief Creates the qt5 mocs for the specified header files.
# @param SRC_LIST The current source list of the project, to which to add the created moc files.
# @param MOC_LIST The list of header files for which to create qt5 mocs.
macro(create_mocs SRC_LIST MOC_LIST)

message( STATUS "${PROJECT_NAME} Creating mocs for: ${ARGN}")

set( MOCABLE_LIST
    ${ARGN}
)

# Empty the MOC_LIST variable
set( ${MOC_LIST}
)

# Create the MOC_LIST
QT5_WRAP_CPP( ${MOC_LIST} ${MOCABLE_LIST} )

# Append SRC_LIST with MOC_LIST
list ( APPEND SRC_LIST
    ${${MOC_LIST}}
)

message( STATUS "${PROJECT_NAME} MOC_LIST: ${${MOC_LIST}}")
message( STATUS "${PROJECT_NAME} SRC_LIST: ${${SRC_LIST}}")

set_source_files_properties(
    ${${MOC_LIST}}
    PROPERTIES
        COMPILE_FLAGS -Wno-undefined-reinterpret-cast
)

endmacro()
